/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.client.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.client.dto.ClientDto;
import com.jxdinfo.hussar.iam.client.manager.EditClientModelManager;
import com.jxdinfo.hussar.iam.client.manager.impl.CommonClientModelManager;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.client.manager.impl.editClientModelManagerImpl")
public class EditClientModelManagerImpl
extends CommonClientModelManager
implements EditClientModelManager {
    @Override
    @HussarTransactional
    public Boolean update(ClientDto clientDto) {
        this.checkSaveOrUpdate(clientDto);
        SysClientModel clientModel = this.clientDtoToModel(clientDto);
        SysClientModel oldClientModel = (SysClientModel)this.sysClientModelService.getById((Serializable)clientModel.getId());
        if (!this.sysClientModelService.updateById((Object)clientModel)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        this.sysClientPermissionService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysClientPermission::getClientId, (Object)oldClientModel.getClientId())).set(SysClientPermission::getClientId, (Object)clientModel.getClientId()));
        SysAuthClientModel oldAuthClientModel = (SysAuthClientModel)this.sysAuthClientModelService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAuthClientModel::getClientId, (Object)oldClientModel.getClientId()));
        if (ToolUtil.isNotEmpty((Object)oldAuthClientModel)) {
            SysAuthClientModel authClientModel = this.clientDtoToAuthModel(clientDto, false);
            authClientModel.setId(oldAuthClientModel.getId());
            authClientModel.setContractScope(oldAuthClientModel.getContractScope());
            authClientModel.setAllowUrl(oldAuthClientModel.getAllowUrl());
            authClientModel.setAuthorizedGrantType(oldAuthClientModel.getAuthorizedGrantType());
            authClientModel.setRefreshTokenValidTime(oldAuthClientModel.getRefreshTokenValidTime());
            this.sysAuthClientModelService.updateAuthClientModel(authClientModel);
        }
        HussarFixedCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return true;
    }

    @Override
    @HussarTransactional
    public String updateClientSecret(Long id) {
        String newSecret = this.generateClientInfoService.getClientSecret();
        SysClientModel clientModel = (SysClientModel)this.sysClientModelService.getById((Serializable)id);
        if (ToolUtil.isEmpty((Object)clientModel)) {
            throw new BaseException("\u672a\u627e\u5230\u5ba2\u6237\u7aef");
        }
        clientModel.setClientSecret(newSecret);
        if (!this.sysClientModelService.updateById((Object)clientModel)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        SysAuthClientModel authClientModel = (SysAuthClientModel)this.sysAuthClientModelService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAuthClientModel::getClientId, (Object)clientModel.getClientId()));
        if (ToolUtil.isNotEmpty((Object)authClientModel)) {
            authClientModel.setClientSecret(newSecret);
            authClientModel.setApplicationId(clientModel.getApplicationId());
            this.sysAuthClientModelService.updateAuthClientModel(authClientModel);
        }
        HussarFixedCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return newSecret;
    }

    @Override
    public Boolean updateClientStatus(String clientId, String clientStatus) {
        Boolean flag = this.sysClientModelService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysClientModel::getClientId, (Object)clientId)).set(SysClientModel::getClientStatus, (Object)clientStatus));
        if ("0".equals(clientStatus)) {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            String tenantCode = ToolUtil.isNotEmpty((Object)securityUser) && ToolUtil.isNotEmpty((Object)securityUser.getTenantCode()) ? securityUser.getTenantCode() : "";
            HussarSecurityUtils.revokeClientToken((String)clientId, (String)tenantCode);
        }
        HussarFixedCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return flag;
    }
}

