/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.service.impl.authentication;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.iam.base.sdk.api.service.authentication.IHussarBaseSysAuthClientModelService;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseSysAuthClientModelServiceImpl
implements IHussarBaseSysAuthClientModelService {
    @Resource
    private ISysClientModelService sysClientModelService;
    @Resource
    private SysAuthClientModelService sysAuthClientModelService;

    public SysAuthClientModel getClientModelByClientId(String clientId, Long applicationId) {
        if (!clientId.equals("hussar-base")) {
            LambdaQueryWrapper sysClientModelLambdaQueryWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)sysClientModelLambdaQueryWrapper.eq(SysClientModel::getClientId, (Object)clientId)).eq(SysClientModel::getApplicationId, (Object)applicationId);
            SysClientModel sysClientModel = (SysClientModel)this.sysClientModelService.getOne((Wrapper)sysClientModelLambdaQueryWrapper, false);
            if (HussarUtils.isEmpty((Object)sysClientModel)) {
                return null;
            }
        }
        LambdaQueryWrapper sysAuthClientModelLambdaQueryWrapper = Wrappers.lambdaQuery();
        sysAuthClientModelLambdaQueryWrapper.eq(SysAuthClientModel::getClientId, (Object)clientId);
        return (SysAuthClientModel)this.sysAuthClientModelService.getOne((Wrapper)sysAuthClientModelLambdaQueryWrapper, false);
    }

    public ClientModelDetails getClientDetailByClientID(String clientId, Long applicationId) {
        ClientModelDetails oldClientModelDetail;
        if (applicationId == null) {
            applicationId = 1L;
        }
        if (HussarUtils.isNotEmpty((Object)(oldClientModelDetail = (ClientModelDetails)HussarCacheUtil.get((String)"security_client_cache", (Object)("security_client_key:" + applicationId + ":" + clientId))))) {
            return oldClientModelDetail;
        }
        SysAuthClientModel one = this.getClientModelByClientId(clientId, applicationId);
        if (HussarUtils.isEmpty((Object)one)) {
            return null;
        }
        ClientModelDetails clientModelDetails = this.sysAuthClientModelService.getClientModelDetailsByClientModel(one);
        HussarCacheUtil.put((String)"security_client_cache", (Object)("security_client_key:" + applicationId + ":" + clientId), (Object)clientModelDetails);
        return clientModelDetails;
    }
}

