/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/roleFunction"})
@Api(tags={"\u89d2\u8272\u529f\u80fd\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseRoleFunctionSdkController {
    @Autowired
    private ISysRoleFunctionsService sysRoleFunctionsService;

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u89d2\u8272\u529f\u80fd\u5173\u8054\u5173\u7cfb", notes="\u6279\u91cf\u4fdd\u5b58\u89d2\u8272\u529f\u80fd\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u89d2\u8272\u529f\u80fd\u7ba1\u7406", eventDesc="\u6279\u91cf\u4fdd\u5b58\u89d2\u8272\u529f\u80fd\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:roleFunction:saveBatch"})
    @PostMapping(value={"/saveBatch"})
    public IamSdkApiResponse<Boolean> saveBatch(@RequestBody List<SysRoleFunctions> sysRoleFunctions) {
        return IamSdkApiResponse.success((Object)this.sysRoleFunctionsService.saveBatch(sysRoleFunctions));
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fdid\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb\u5217\u8868", notes="\u6839\u636e\u529f\u80fdid\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fdid\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:roleFunction:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<SysRoleFunctions>> list(@RequestBody Long functionId) {
        List sysRoleFunctions = this.sysRoleFunctionsService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)functionId));
        return IamSdkApiResponse.success((Object)sysRoleFunctions);
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u529f\u80fd\u5173\u8054\u5173\u7cfb", notes="\u6839\u636e\u89d2\u8272id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u529f\u80fd\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u89d2\u8272\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u89d2\u8272id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u529f\u80fd\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:roleFunction:listByRoleIds"})
    @PostMapping(value={"/listByRoleIds"})
    public IamSdkApiResponse<List<SysRoleFunctions>> listByRoleIds(@RequestBody List<Long> roleIds) {
        List sysRoleFunctions = this.sysRoleFunctionsService.list((Wrapper)new LambdaQueryWrapper().in(SysRoleFunctions::getRoleId, roleIds));
        return IamSdkApiResponse.success((Object)sysRoleFunctions);
    }
}

