/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.permission;

import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryFunctionResourceDto;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/functionResource"})
@Api(tags={"\u529f\u80fd\u8d44\u6e90\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseFunctionResourceSdkController {
    @Autowired
    private ISysFunctionResourcesService sysFunctionResourcesService;

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", notes="\u6279\u91cf\u4fdd\u5b58\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u529f\u80fd\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6279\u91cf\u4fdd\u5b58\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:functionResource:saveBatch"})
    @PostMapping(value={"/saveBatch"})
    public IamSdkApiResponse<Boolean> saveBatch(@RequestBody List<SysFunctionResources> sysFunctionResources) {
        return IamSdkApiResponse.success((Object)this.sysFunctionResourcesService.saveBatch(sysFunctionResources));
    }

    @ApiOperation(value="\u67e5\u8be2\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", notes="\u67e5\u8be2\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u529f\u80fd\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:functionResource:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<SysFunctionResources>> list(@RequestBody IamQueryFunctionResourceDto iamQueryFunctionResourceDto) {
        Long functionId = iamQueryFunctionResourceDto.getFunctionId();
        Long resourceId = iamQueryFunctionResourceDto.getResourceId();
        return IamSdkApiResponse.success((Object)this.sysFunctionResourcesService.listByFuncIdAndResId(functionId, resourceId));
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90id\u96c6\u5408\u67e5\u8be2\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", notes="\u6839\u636e\u8d44\u6e90id\u96c6\u5408\u67e5\u8be2\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u529f\u80fd\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90id\u96c6\u5408\u67e5\u8be2\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:functionResource:listByResIds"})
    @PostMapping(value={"/listByResIds"})
    public IamSdkApiResponse<List<SysFunctionResources>> listByResIds(@RequestBody List<Long> resIds) {
        return IamSdkApiResponse.success((Object)this.sysFunctionResourcesService.listByResIds(resIds));
    }

    @ApiOperation(value="\u4fdd\u5b58\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", notes="\u4fdd\u5b58\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u529f\u80fd\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:functionResource:save"})
    @PostMapping(value={"/save"})
    public IamSdkApiResponse<Boolean> save(@RequestBody SysFunctionResources sysFunctionResources) {
        return IamSdkApiResponse.success((Object)this.sysFunctionResourcesService.save((Object)sysFunctionResources));
    }
}

