/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.identity;

import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SimpleOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/organ"})
@Api(tags={"\u7ec4\u7ec7\u673a\u6784\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseOrganSdkController {
    @Resource
    private IHussarBaseStaffService staffServiceImpl;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private IHussarBaseOrganizationService iHussarBaseOrganizationService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysOrganTypeService sysOrganTypeService;

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u57fa\u7840\u4fe1\u606f", notes="\u83b7\u53d6\u7ec4\u7ec7\u57fa\u7840\u4fe1\u606f")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u57fa\u7840\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:organ:getSimpleOrgan"})
    @PostMapping(value={"/getSimpleOrgan"})
    public IamSdkApiResponse<List<SimpleOrganVo>> getSimpleOrgan(@RequestBody List<Long> organIds) {
        return IamSdkApiResponse.success((Object)this.staffServiceImpl.getSimpleOrgan(organIds));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f", notes="\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:organ:getOrgInfoByOrgId"})
    @PostMapping(value={"/getOrgInfoByOrgId"})
    public IamSdkApiResponse<SysOrganVo> getOrgInfoByOrgId(@RequestBody Long organId) {
        return IamSdkApiResponse.success((Object)this.iSysStruService.getOrgInfoByOrgId(organId));
    }

    @ApiOperation(value="\u5237\u65b0\u7ec4\u7ec7\u673a\u6784", notes="\u5237\u65b0\u7ec4\u7ec7\u673a\u6784")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u5bf9\u5916\u63a5\u53e3", eventDesc="\u5237\u65b0\u7ec4\u7ec7\u673a\u6784", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:organ:refreshOrgan"})
    @PostMapping(value={"/refreshOrgan"})
    public IamSdkApiResponse<Object> refreshOrgan() {
        this.iHussarBaseOrganizationService.refreshOrgan();
        return IamSdkApiResponse.success();
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5217\u8868")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:organ:getOrgansByParentId"})
    @PostMapping(value={"/getOrgansByParentId"})
    public IamSdkApiResponse<List<SysOrgan>> listByIds(@RequestBody List<Long> organIds) {
        return IamSdkApiResponse.success((Object)this.sysOrganService.listByIds(organIds));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u56fe\u6807", notes="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u56fe\u6807")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u56fe\u6807", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:organ:getDeptIcon"})
    @PostMapping(value={"/getDeptIcon"})
    public IamSdkApiResponse<String> getDeptIcon(@RequestBody(required=false) Long organId) {
        if (HussarUtils.isEmpty((Object)organId)) {
            return IamSdkApiResponse.success((String)"");
        }
        return IamSdkApiResponse.success((String)this.sysOrganTypeService.getDeptIcon(organId));
    }
}

