/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.account;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryUserDTO;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/user"})
@Api(tags={"\u7528\u6237\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseUserSdkController {
    @Resource
    private ISysUsersService sysUsersService;

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7528\u6237", notes="\u6839\u636eid\u67e5\u8be2\u7528\u6237")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6839\u636eid\u67e5\u8be2\u7528\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:user:getById"})
    @PostMapping(value={"/getById"})
    public IamSdkApiResponse<SysUsers> getById(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.sysUsersService.getById(userId));
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u4fe1\u606f", notes="\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916\u63a5\u53e3", eventDesc="\u67e5\u8be2\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:user:getOne"})
    @PostMapping(value={"/getOne"})
    public IamSdkApiResponse<SysUsers> getOne(@RequestBody IamQueryUserDTO queryUserDTO) {
        return IamSdkApiResponse.success((Object)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)queryUserDTO.getUserAccount())).in(HussarUtils.isNotEmpty((Object)queryUserDTO.getAccountStatus()), SysUsers::getAccountStatus, (Collection)queryUserDTO.getAccountStatus())));
    }

    @ApiOperation(value="\u6839\u636eid\u5217\u8868\u67e5\u8be2\u7528\u6237\u5217\u8868", notes="\u6839\u636eid\u5217\u8868\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6839\u636eid\u5217\u8868\u67e5\u8be2\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:user:listByIds"})
    @PostMapping(value={"/listByIds"})
    public IamSdkApiResponse<List<SysUsers>> listByIds(@RequestBody List<Long> userIds) {
        List users = this.sysUsersService.listByIds(userIds);
        return IamSdkApiResponse.success((Object)users);
    }

    @ApiOperation(value="\u83b7\u53d6\u8fc7\u671f\u7684\u4e34\u65f6\u8d26\u53f7", notes="\u83b7\u53d6\u8fc7\u671f\u7684\u4e34\u65f6\u8d26\u53f7")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u8fc7\u671f\u7684\u4e34\u65f6\u8d26\u53f7", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:user:getExpiredTemporary"})
    @PostMapping(value={"/getExpiredTemporary"})
    public IamSdkApiResponse<List<SysUsers>> getExpiredTemporary(@RequestBody LocalDateTime endTime) {
        List users = this.sysUsersService.getExpireTemporaty(endTime);
        return IamSdkApiResponse.success((Object)users);
    }

    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u7528\u6237\u4fe1\u606f", notes="\u6279\u91cf\u66f4\u65b0\u7528\u6237\u4fe1\u606f")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6279\u91cf\u66f4\u65b0\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:user:updateBatchById"})
    @PostMapping(value={"/updateBatchById"})
    public IamSdkApiResponse updateBatchById(@RequestBody List<SysUsers> users) {
        this.sysUsersService.updateBatchById(users);
        return IamSdkApiResponse.success();
    }

    @ApiOperation(value="\u7528\u6237\u8d26\u53f7\u662f\u5426\u5df2\u5b58\u5728", notes="\u7528\u6237\u8d26\u53f7\u662f\u5426\u5df2\u5b58\u5728")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916\u63a5\u53e3", eventDesc="\u7528\u6237\u8d26\u53f7\u662f\u5426\u5df2\u5b58\u5728", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:user:isExistAccount"})
    @PostMapping(value={"/isExistAccount"})
    public IamSdkApiResponse<Boolean> isExistAccount(@RequestBody String userAccount) {
        return IamSdkApiResponse.success((Object)this.sysUsersService.isExistAccount(userAccount));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5386\u53f2\u5bc6\u7801", notes="\u83b7\u53d6\u7528\u6237\u5386\u53f2\u5bc6\u7801")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u7528\u6237\u5386\u53f2\u5bc6\u7801", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:user:getPwdHist"})
    @PostMapping(value={"/getPwdHist"})
    public IamSdkApiResponse<List<SysPasswordHist>> getPwdHist(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.sysUsersService.getPwdHist(userId));
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u5bc6\u7801", notes="\u66f4\u65b0\u7528\u6237\u5bc6\u7801")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916\u63a5\u53e3", eventDesc="\u66f4\u65b0\u7528\u6237\u5bc6\u7801", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:user:updatePwd"})
    @PostMapping(value={"/updatePwd"})
    public IamSdkApiResponse updatePwd(@RequestBody SysUsers sysUsers) {
        this.sysUsersService.updatePwd(sysUsers);
        return IamSdkApiResponse.success();
    }
}

