/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.account;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamFeignQueryOrganUserDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamFeignQueryUserDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamFeignSearchUserDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamSearchOrganUserDto;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.OrganUserTreeVo;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/feign/user"})
@Api(tags={"\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3"})
public class HussarBaseFeignUserSdkController {
    @Autowired
    private IHussarBaseUserBoService hussarBaseUserBoService;

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u96c6\u5408\u3001\u7528\u6237id\u96c6\u5408\u83b7\u53d6\u53bb\u91cd\u7684\u7528\u6237\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7id\u96c6\u5408\u3001\u7528\u6237id\u96c6\u5408\u83b7\u53d6\u53bb\u91cd\u7684\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u7ec4\u7ec7id\u96c6\u5408\u3001\u7528\u6237id\u96c6\u5408\u83b7\u53d6\u53bb\u91cd\u7684\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:getUsersByOrganUser"})
    @PostMapping(value={"/getUsersByOrganUser"})
    public IamSdkApiResponse<List<UserVo>> getUsersByOrganUser(@RequestBody IamFeignQueryUserDTO feignQueryUserDTO) {
        List struIds = feignQueryUserDTO.getStruIds();
        List userIds = feignQueryUserDTO.getUserIds();
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.getUsersByOrganUser(struIds, userIds));
    }

    @ApiOperation(value="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811", notes="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811\u8868")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:lazyOrganUserTree"})
    @PostMapping(value={"/lazyOrganUserTree"})
    public IamSdkApiResponse<List<OrganUserTreeVo>> lazyOrganUserTree(@RequestBody IamFeignQueryOrganUserDTO feignQueryOrganUserDTO) {
        Boolean needParent = feignQueryOrganUserDTO.getNeedParentOrganInfo();
        List parentIds = feignQueryOrganUserDTO.getParentOrganIds();
        Integer resultType = feignQueryOrganUserDTO.getResultType();
        List treeVos = this.hussarBaseUserBoService.lazyOrganUserTree(parentIds, needParent, resultType);
        List iamOrganUserTreeVo = JSON.parseArray((String)JSON.toJSONString((Object)treeVos), OrganUserTreeVo.class);
        return IamSdkApiResponse.success((Object)iamOrganUserTreeVo);
    }

    @ApiOperation(value="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u5217\u8868", notes="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:searchUser"})
    @PostMapping(value={"/searchUser"})
    public IamSdkApiResponse<Page<SearchUserTreeVo>> searchUser(@RequestBody IamSearchOrganUserDto organUserDto) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setCurrent(organUserDto.getCurrent());
        pageInfo.setSize(organUserDto.getSize());
        SearchOrganUserDto searchOrganUserDto = new SearchOrganUserDto();
        String name = organUserDto.getName();
        String resultType = organUserDto.getResultType();
        List organIds = organUserDto.getOrganIds();
        List userIds = organUserDto.getUserIds();
        searchOrganUserDto.setName(name);
        searchOrganUserDto.setResultType(resultType);
        searchOrganUserDto.setOrganIds(organIds);
        searchOrganUserDto.setUserIds(userIds);
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.searchUser(pageInfo, searchOrganUserDto));
    }

    @ApiOperation(value="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4eba\u5458\u4fe1\u606f", notes="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4eba\u5458\u4fe1\u606f")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u7ec4\u7ec7/\u7528\u6237\u9009\u62e9\u7ec4\u4ef6-\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4eba\u5458\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:getUserAndStaffInfo"})
    @PostMapping(value={"/getUserAndStaffInfo"})
    public IamSdkApiResponse<UserStaffVo> getUserAndStaffInfo(@RequestBody Long userId) {
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.getUserAndStaffInfo(userId));
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:searchUsers"})
    @PostMapping(value={"/searchUsers"})
    public IamSdkApiResponse<Page<SearchUserVo>> searchUsers(@RequestBody IamFeignSearchUserDTO feignSearchUserDTO) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setCurrent(feignSearchUserDTO.getCurrent());
        pageInfo.setSize(feignSearchUserDTO.getSize());
        QueryUserDto queryUserDto = feignSearchUserDTO.getQueryUserDto();
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.searchUsers(pageInfo, queryUserDto));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237ID\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u7528\u6237ID\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:getUserInfo"})
    @PostMapping(value={"/getUserInfo"})
    public IamSdkApiResponse<Map<Long, SysUsers>> getUserInfo(@RequestBody List<Long> userIds) {
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.getUserInfo(userIds));
    }

    @ApiOperation(value="\u5e94\u7528\u8bbf\u95ee\u6743\u9650-\u83b7\u53d6\u7528\u6237\u5206\u9875\u5217\u8868", notes="\u5e94\u7528\u8bbf\u95ee\u6743\u9650-\u83b7\u53d6\u7528\u6237\u5206\u9875\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u5e94\u7528\u8bbf\u95ee\u6743\u9650-\u83b7\u53d6\u7528\u6237\u5206\u9875\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:getUserList"})
    @PostMapping(value={"/getUserList"})
    public IamSdkApiResponse<Page<SearchUserVo>> getUserList(@RequestBody IamFeignSearchUserDTO feignSearchUserDTO) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setCurrent(feignSearchUserDTO.getCurrent());
        pageInfo.setSize(feignSearchUserDTO.getSize());
        QueryUserDto queryUserDto = feignSearchUserDTO.getQueryUserDto();
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.getUserList(pageInfo, queryUserDto.getUserName(), queryUserDto.getUserAccount()));
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272id\u83b7\u53d6\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u89d2\u8272id\u83b7\u53d6\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u89d2\u8272id\u83b7\u53d6\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:getUserInfoByRoleId"})
    @PostMapping(value={"/getUserInfoByRoleId"})
    public IamSdkApiResponse<List<UserVo>> getUserInfoByRoleId(@RequestBody List<Long> roleIds) {
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.getUserInfoByRoleId(roleIds));
    }

    @ApiOperation(value="\u6839\u636e\u5c97\u4f4dID\u96c6\u5408\u83b7\u53d6\u5c97\u4f4d\u5173\u8054\u7684\u7528\u6237", notes="\u6839\u636e\u5c97\u4f4dID\u96c6\u5408\u83b7\u53d6\u5c97\u4f4d\u5173\u8054\u7684\u7528\u6237")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u5c97\u4f4dID\u96c6\u5408\u83b7\u53d6\u5c97\u4f4d\u5173\u8054\u7684\u7528\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:getUsersByPostIds"})
    @PostMapping(value={"/getUsersByPostIds"})
    public IamSdkApiResponse<List<UserVo>> getUsersByPostIds(@RequestBody List<Long> postIds) {
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.getUsersByPostIds(postIds));
    }

    @ApiOperation(value="\u901a\u8fc7\u7ec4\u7ec7id\u96c6\u5408\u83b7\u53d6\u7ec4\u7ec7\u7528\u6237\u5173\u8054\u4fe1\u606f", notes="\u901a\u8fc7\u7ec4\u7ec7id\u96c6\u5408\u83b7\u53d6\u7ec4\u7ec7\u7528\u6237\u5173\u8054\u4fe1\u606f")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u901a\u8fc7\u7ec4\u7ec7id\u96c6\u5408\u83b7\u53d6\u7ec4\u7ec7\u7528\u6237\u5173\u8054\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:getStruUserByStruIds"})
    @PostMapping(value={"/getStruUserByStruIds"})
    public IamSdkApiResponse<List<SysStruUser>> getStruUserByStruIds(@RequestBody List<Long> struIds) {
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.getStruUserByStruIds(struIds));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ids\u4ee5\u53ca\u89d2\u8272\u6743\u9650\u67e5\u8be2\u5bf9\u5e94\u7684\u7528\u6237\u5217\u8868", notes="\u6839\u636e\u7528\u6237ids\u4ee5\u53ca\u89d2\u8272\u6743\u9650\u67e5\u8be2\u5bf9\u5e94\u7684\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u7528\u6237ids\u4ee5\u53ca\u89d2\u8272\u6743\u9650\u67e5\u8be2\u5bf9\u5e94\u7684\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:getUserIdsByUserIdsAndRolePermission"})
    @PostMapping(value={"/getUserIdsByUserIdsAndRolePermission"})
    public IamSdkApiResponse<List<String>> getUserIdsByUserIdsAndRolePermission(@RequestBody IamFeignQueryUserDTO feignQueryUserDTO) {
        List userIds = feignQueryUserDTO.getUserIds();
        String permission = feignQueryUserDTO.getRolePermission();
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.getUserIdsByUserIdsAndRolePermission(userIds, permission));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u7528\u6237", notes="\u6839\u636e\u7528\u6237\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u7528\u6237")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u6839\u636e\u7528\u6237\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u7528\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:organUserSearch"})
    @PostMapping(value={"/organUserSearch"})
    public IamSdkApiResponse<List<OrganUserTreeVo>> organUserSearch(@RequestBody(required=false) String userName) {
        List treeVos = this.hussarBaseUserBoService.organUserSearch(userName);
        List iamOrganUserTreeVo = JSON.parseArray((String)JSON.toJSONString((Object)treeVos), OrganUserTreeVo.class);
        return IamSdkApiResponse.success((Object)iamOrganUserTreeVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8\u7528\u6237\u5217\u8868", notes="\u67e5\u8be2\u5168\u90e8\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u5bf9\u5916feign\u63a5\u53e3", eventDesc="\u67e5\u8be2\u5168\u90e8\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:feign:user:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<SysUsers>> list() {
        return IamSdkApiResponse.success((Object)this.hussarBaseUserBoService.list());
    }
}

