/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/organrole"})
@Api(tags={"\u7ec4\u7ec7\u89d2\u8272\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseStruRoleSdkController {
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysStruRoleService sysStruRoleService;

    @ApiOperation(value="\u901a\u8fc7\u7ec4\u7ec7id\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u89d2\u8272id\u96c6\u5408", notes="\u901a\u8fc7\u7ec4\u7ec7id\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u89d2\u8272id\u96c6\u5408")
    @AuditLog(moduleName="\u7ec4\u7ec7\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u901a\u8fc7\u7ec4\u7ec7id\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u89d2\u8272id\u96c6\u5408", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:organrole:roleIdList"})
    @PostMapping(value={"/roleIdList"})
    public IamSdkApiResponse<List<Long>> roleIdList(@RequestBody Long organId) {
        Long appId = ApplicationUtils.getApplicationId();
        List roles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)roles)) {
            return IamSdkApiResponse.success(Collections.emptyList());
        }
        List struRoles = this.sysStruRoleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)organId)).in(SysStruRole::getGrantedRole, (Collection)roles)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List roleIds = struRoles.stream().map(SysStruRole::getGrantedRole).distinct().collect(Collectors.toList());
        return IamSdkApiResponse.success(roleIds);
    }
}

