/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.permission;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryRoleDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.service.permission.IamSdkRoleService;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.iam.base.sdk.api.vo.WorkTempRoleSearchVo;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/role"})
@Api(tags={"\u89d2\u8272\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseRoleSdkController {
    @Autowired
    private ISysRoleGroupService sysRoleGroupService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysRolesExternalService sysRolesExternalService;
    @Autowired
    private IamSdkRoleService iamSdkRoleService;

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u89d2\u8272\u6811", notes="\u61d2\u52a0\u8f7d\u89d2\u8272\u6811")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u61d2\u52a0\u8f7d\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:getLazyRoleTree"})
    @PostMapping(value={"/getLazyRoleTree"})
    public IamSdkApiResponse<List<JSTreeModel>> getLazyRoleTree(@RequestBody Long nodeId) {
        Long appId = ApplicationUtils.getApplicationId();
        List iamJsTreeModels = this.iamSdkRoleService.getLazyRoleTree(nodeId, appId);
        return IamSdkApiResponse.success((Object)iamJsTreeModels);
    }

    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272id\u96c6\u5408\u83b7\u53d6\u89d2\u8272\u5217\u8868", notes="\u901a\u8fc7\u89d2\u8272id\u96c6\u5408\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u901a\u8fc7\u89d2\u8272id\u96c6\u5408\u83b7\u53d6\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:listByIds"})
    @PostMapping(value={"/listByIds"})
    public IamSdkApiResponse<List<SysRoles>> listByIds(@RequestBody List<Long> idList) {
        return IamSdkApiResponse.success((Object)this.sysRolesService.listByIds(idList));
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u540d\u5217\u8868\u83b7\u53d6\u672c\u5e94\u7528\u4e0b\u89d2\u8272id\u5217\u8868", notes="\u6839\u636e\u89d2\u8272\u540d\u5217\u8868\u83b7\u53d6\u672c\u5e94\u7528\u4e0b\u89d2\u8272id\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6839\u636e\u89d2\u8272\u540d\u5217\u8868\u83b7\u53d6\u672c\u5e94\u7528\u4e0b\u89d2\u8272id\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:getRoleIdByRoleName"})
    @PostMapping(value={"/getRoleIdByRoleName"})
    public IamSdkApiResponse<List<Long>> getRoleIdByRoleName(@RequestBody List<String> roleNames) {
        if (HussarUtils.isEmpty(roleNames)) {
            return IamSdkApiResponse.success(Collections.emptyList());
        }
        Long appId = ApplicationUtils.getApplicationId();
        List roles = this.sysRolesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId)).in(SysRoles::getRoleName, roleNames));
        List roleIds = roles.stream().map(SysRoles::getId).collect(Collectors.toList());
        return IamSdkApiResponse.success(roleIds);
    }

    @ApiOperation(value="\u65b0\u589e\u5e94\u7528\u5f00\u53d1\u8005\u89d2\u8272", notes="\u65b0\u589e\u5e94\u7528\u5f00\u53d1\u8005\u89d2\u8272")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u65b0\u589e\u5e94\u7528\u5f00\u53d1\u8005\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:role:addAppDevRole"})
    @PostMapping(value={"/addAppDevRole"})
    public IamSdkApiResponse<Long> addAppDevRole(@RequestBody String appName) {
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.sysRolesExternalService.addAppDevRole(appName, appId).getData());
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7ec4\u4e0b\u89d2\u8272id\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u7ec4\u4e0b\u89d2\u8272id\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u89d2\u8272\u7ec4\u4e0b\u89d2\u8272id\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:getRoleIdByGroupId"})
    @PostMapping(value={"/getRoleIdByGroupId"})
    public IamSdkApiResponse<List<Long>> getRoleIdByGroupId(@RequestBody List<String> groupNames) {
        List groups = this.sysRoleGroupService.list((Wrapper)new LambdaQueryWrapper().in(SysRoleGroup::getGroupName, groupNames));
        if (HussarUtils.isEmpty((Object)groups)) {
            return IamSdkApiResponse.success(Collections.emptyList());
        }
        List groupIds = groups.stream().map(SysRoleGroup::getId).collect(Collectors.toList());
        List roles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getGroupId, groupIds));
        List roleIds = roles.stream().map(SysRoles::getId).collect(Collectors.toList());
        return IamSdkApiResponse.success(roleIds);
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u5f00\u53d1\u89d2\u8272", notes="\u5220\u9664\u5e94\u7528\u5f00\u53d1\u89d2\u8272")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u5220\u9664\u5e94\u7528\u5f00\u53d1\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"iamBaseSdk:role:deleteDevelopRole"})
    @PostMapping(value={"/deleteDevelopRole"})
    public IamSdkApiResponse deleteDevelopRole(@RequestBody Long roleId) {
        this.sysRolesExternalService.delRole(roleId);
        return IamSdkApiResponse.success();
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272id\u6279\u91cf\u83b7\u53d6\u89d2\u8272\u4fe1\u606f", notes="\u6839\u636e\u89d2\u8272id\u6279\u91cf\u83b7\u53d6\u89d2\u8272\u4fe1\u606f")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u89d2\u8272\u7ec4\u4e0b\u89d2\u8272id\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:getRoleInfoByIds"})
    @PostMapping(value={"/getRoleInfoByIds"})
    public IamSdkApiResponse<List<RoleVo>> getRoleInfoByIds(@RequestBody List<Long> roleIds) {
        List roleVoList = this.sysRolesExternalService.getRoleInfoByIds(roleIds);
        return IamSdkApiResponse.success((Object)roleVoList);
    }

    @ApiOperation(value="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d", notes="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:roleGroupTree"})
    @PostMapping(value={"/roleGroupTree"})
    public IamSdkApiResponse<List<JSTreeModel>> loadRoleGruopTree(@RequestBody(required=false) Long appId) {
        appId = ApplicationUtils.getApplicationId();
        List roleGroupTree = this.sysRolesService.getRoleGroupTree(appId);
        List iamJsTreeModels = JSON.parseArray((String)JSON.toJSONString((Object)roleGroupTree), JSTreeModel.class);
        return IamSdkApiResponse.success((Object)iamJsTreeModels);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272", notes="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:searchRoleToGroup"})
    @PostMapping(value={"/searchRoleToGroup"})
    public IamSdkApiResponse<List<SysRoles>> searchRoleToGroup(@RequestBody IamQueryRoleDTO queryRoleDTO) {
        Long groupId = queryRoleDTO.getRoleGroupId();
        String roleName = queryRoleDTO.getRoleName();
        List roles = this.sysRolesExternalService.searchRoleToGroup(groupId, roleName);
        return IamSdkApiResponse.success((Object)roles);
    }

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u6811")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u52a0\u8f7d\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:searchRoleToGroup"})
    @PostMapping(value={"/getRoleTree"})
    public IamSdkApiResponse<List<ReadOnlyRoleTreeVo>> getRoleTree() {
        Long appId = ApplicationUtils.getApplicationId();
        List roleTree = this.sysRolesExternalService.getRoleTree(appId);
        List iamTree = JSON.parseArray((String)JSON.toJSONString((Object)roleTree), ReadOnlyRoleTreeVo.class);
        return IamSdkApiResponse.success((Object)iamTree);
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u89d2\u8272", notes="\u6839\u636e\u89d2\u8272\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u89d2\u8272")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6839\u636e\u89d2\u8272\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:roleSearch"})
    @PostMapping(value={"/roleSearch"})
    public IamSdkApiResponse<List<WorkTempRoleSearchVo>> roleSearch(@RequestBody(required=false) String roleName) {
        Long appId = ApplicationUtils.getApplicationId();
        List vos = this.sysRolesExternalService.roleSearch(roleName, appId);
        List searchVos = JSON.parseArray((String)JSON.toJSONString((Object)vos), WorkTempRoleSearchVo.class);
        return IamSdkApiResponse.success((Object)searchVos);
    }

    @ApiOperation(value="\u67e5\u770b\u89d2\u8272\u4fe1\u606f", notes="\u67e5\u770b\u89d2\u8272\u4fe1\u606f")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u67e5\u770b\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:getRoleViewMap"})
    @PostMapping(value={"/getRoleViewMap"})
    public IamSdkApiResponse<RoleInfoVO> getRoleViewMap(@RequestBody Long roleId) {
        RoleInfoVO viewMap = this.sysRolesExternalService.getRoleViewMap(roleId);
        return IamSdkApiResponse.success((Object)viewMap);
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272", notes="\u4fee\u6539\u89d2\u8272")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u4fee\u6539\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:role:updateRole"})
    @PostMapping(value={"/updateRole"})
    public IamSdkApiResponse<Boolean> updateRole(@RequestBody SysRoles updateRole) {
        return IamSdkApiResponse.success((Object)this.sysRolesExternalService.updateRole(updateRole));
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272id\u6279\u91cf\u83b7\u53d6\u89d2\u8272\u4fe1\u606f", notes="\u6839\u636e\u89d2\u8272id\u6279\u91cf\u83b7\u53d6\u89d2\u8272\u4fe1\u606f")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6839\u636e\u89d2\u8272id\u6279\u91cf\u83b7\u53d6\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:getRolesByIds"})
    @PostMapping(value={"/getRolesByIds"})
    public IamSdkApiResponse<List<SysRoles>> getRolesByIds(@RequestBody List<Long> roleIds) {
        List list = this.sysRolesExternalService.getRolesByIds(roleIds);
        return IamSdkApiResponse.success((Object)list);
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u89d2\u8272", notes="\u83b7\u53d6\u5168\u90e8\u89d2\u8272")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u5168\u90e8\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:getAllRoles"})
    @PostMapping(value={"/getAllRoles"})
    public IamSdkApiResponse<List<SysRoles>> getAllRoles() {
        Long appId = ApplicationUtils.getApplicationId();
        List list = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId));
        return IamSdkApiResponse.success((Object)list);
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u89d2\u8272", notes="\u6279\u91cf\u65b0\u589e\u89d2\u8272")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6279\u91cf\u65b0\u589e\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:role:saveRoleBatch"})
    @PostMapping(value={"/saveRoleBatch"})
    public IamSdkApiResponse<Boolean> saveRoleBatch(@RequestBody List<SysRoles> roleList) {
        Long appId = ApplicationUtils.getApplicationId();
        for (SysRoles role : roleList) {
            role.setAppId(appId);
        }
        boolean result = this.sysRolesExternalService.saveRoleBatch(roleList);
        return IamSdkApiResponse.success((Object)result);
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u5206\u7ec4Id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u5206\u7ec4", notes="\u6839\u636e\u89d2\u8272\u5206\u7ec4Id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u5206\u7ec4")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6839\u636e\u89d2\u8272\u5206\u7ec4Id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:selectRoleGroupByIds"})
    @PostMapping(value={"/selectRoleGroupByIds"})
    public IamSdkApiResponse<List<SysRoleGroup>> selectRoleGroupByIds(@RequestBody List<Long> roleGroupIds) {
        List list = this.sysRolesExternalService.selectRoleGroupByIds(roleGroupIds);
        return IamSdkApiResponse.success((Object)list);
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u89d2\u8272\u5206\u7ec4", notes="\u83b7\u53d6\u5168\u90e8\u89d2\u8272\u5206\u7ec4")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u5168\u90e8\u89d2\u8272\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:role:getAllRoleGroup"})
    @PostMapping(value={"/getAllRoleGroup"})
    public IamSdkApiResponse<List<SysRoleGroup>> getAllRoleGroup() {
        Long appId = ApplicationUtils.getApplicationId();
        List list = this.sysRoleGroupService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getAppId, (Object)appId));
        return IamSdkApiResponse.success((Object)list);
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u89d2\u8272\u5206\u7ec4", notes="\u6279\u91cf\u65b0\u589e\u89d2\u8272\u5206\u7ec4")
    @AuditLog(moduleName="\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u6279\u91cf\u65b0\u589e\u89d2\u8272\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:role:saveRoleGroupBatch"})
    @PostMapping(value={"/saveRoleGroupBatch"})
    public IamSdkApiResponse<Boolean> saveRoleGroupBatch(@RequestBody List<SysRoleGroup> roleGroupList) {
        Long appId = ApplicationUtils.getApplicationId();
        for (SysRoleGroup group : roleGroupList) {
            group.setAppId(appId);
        }
        boolean result = this.sysRolesExternalService.saveRoleGroupBatch(roleGroupList);
        return IamSdkApiResponse.success((Object)result);
    }
}

