/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.service.impl.identity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightCacheVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.base.sdk.api.service.identity.IamSdkDataScopeService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datascope.core.enums.DataScopeEnum;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class IamSdkDataScopeServiceImpl
implements IamSdkDataScopeService {
    @Lazy
    @Resource
    private ISysUsersService usersService;
    @Lazy
    @Resource
    private SysStruMapper sysStruMapper;
    @Lazy
    @Resource
    private ISysStruAssistOrganService assistOrganService;

    public List<DataScopeInfo> getDataScope(Long userId, List<Long> roleIds, String mapper, String serverName) {
        List<Object> dataRightCacheVoList = new ArrayList();
        if (HussarUtils.isNotEmpty(roleIds)) {
            for (Long roleId : roleIds) {
                List cacheList = (List)HussarCacheUtil.get((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId));
                if (!HussarUtils.isNotEmpty((Object)cacheList)) continue;
                dataRightCacheVoList.addAll(cacheList);
            }
            if (HussarUtils.isNotBlank((CharSequence)serverName)) {
                dataRightCacheVoList = dataRightCacheVoList.stream().filter(item -> item.getServerName().equals(serverName)).collect(Collectors.toList());
            }
        }
        if (HussarUtils.isEmpty(dataRightCacheVoList)) {
            return null;
        }
        DataScopeInfo dataRightScopeVo = new DataScopeInfo();
        ArrayList<DataScopeInfo> customDataRights = new ArrayList<DataScopeInfo>();
        List<Long> deptIdList = new ArrayList<Long>();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        ArrayList customdeptIdList = new ArrayList();
        for (DataRightCacheVo dataRightCacheVo : dataRightCacheVoList) {
            if (!mapper.equals(dataRightCacheVo.getMapper())) continue;
            if (HussarUtils.equals((Object)"res_rights", (Object)dataRightCacheVo.getResTypeCode())) {
                dataRightScopeVo.setUserScopeField(dataRightCacheVo.getUserRight());
                dataRightScopeVo.setDeptScopeField(dataRightCacheVo.getDeptRight());
                dataRightScopeVo.setResTypeCode(dataRightCacheVo.getResTypeCode());
                typeList.add(dataRightCacheVo.getType());
                if (!ToolUtil.isNotEmpty((Object)dataRightCacheVo.getDeptId())) continue;
                customdeptIdList.addAll(dataRightCacheVo.getDeptId());
                continue;
            }
            DataScopeInfo customVo = new DataScopeInfo();
            customVo.setResTypeCode(dataRightCacheVo.getResTypeCode());
            customVo.setScopeLabel(dataRightCacheVo.getDataScopeLabel());
            customVo.setCustomDataConditionValueMap((Map)JSON.parseObject((String)dataRightCacheVo.getCustomDataCondition(), Map.class));
            customDataRights.add(customVo);
        }
        ArrayList<DataScopeInfo> dataScopeInfos = new ArrayList<DataScopeInfo>();
        if (HussarUtils.isNotEmpty(typeList)) {
            SysUsers sysUsers = this.usersService.getUser(userId);
            int min = (Integer)Collections.min(typeList);
            if (min == DataScopeEnum.OWN_DEPT_CHILD.getType()) {
                deptIdList.addAll(this.getDeptIds(sysUsers, true));
            } else if (min == DataScopeEnum.OWN_DEPT.getType()) {
                deptIdList.addAll(this.getDeptIds(sysUsers, false));
            } else if (min == DataScopeEnum.CUSTOM.getType()) {
                deptIdList.addAll(customdeptIdList);
            }
            deptIdList = deptIdList.stream().distinct().collect(Collectors.toList());
            dataRightScopeVo.setScopeTypes(typeList);
            dataRightScopeVo.setScopeDeptIds(deptIdList);
            dataScopeInfos.add(dataRightScopeVo);
        }
        dataScopeInfos.addAll(customDataRights);
        return dataScopeInfos;
    }

    private List<Long> getDeptIds(SysUsers sysUsers, boolean hasChildren) {
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        deptIdList.add(sysUsers.getDepartmentId());
        deptIdList.addAll(this.getAssitStru(sysUsers.getEmployeeId()));
        if (hasChildren) {
            deptIdList.addAll(this.getChildren(deptIdList));
        }
        return deptIdList;
    }

    private List<Long> getAssitStru(Long struId) {
        List list = this.assistOrganService.list((Wrapper)new LambdaQueryWrapper(SysStruAssistOrgan.class).eq(SysStruAssistOrgan::getStruId, (Object)struId));
        return list.stream().map(SysStruAssistOrgan::getAssistParentId).collect(Collectors.toList());
    }

    private List<Long> getChildren(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(SysStru.class);
        List sysStrus = this.sysStruMapper.selectList((Wrapper)wrapper.in(SysStru::getId, struIds));
        wrapper.clear();
        sysStrus.forEach(stru -> ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)stru.getStruFid()));
        List children = this.sysStruMapper.selectList((Wrapper)wrapper);
        return children.stream().map(SysStru::getId).collect(Collectors.toList());
    }
}

