/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/userrole"})
@Api(tags={"\u7528\u6237\u89d2\u8272\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseUserRoleSdkController {
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysRolesExternalService sysRolesExternalService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5728\u5f53\u524d\u5e94\u7528\u4e0b\u7684\u89d2\u8272id\u5217\u8868", notes="\u83b7\u53d6\u7528\u6237\u5728\u5f53\u524d\u5e94\u7528\u4e0b\u7684\u89d2\u8272id\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u7528\u6237\u5728\u5f53\u524d\u5e94\u7528\u4e0b\u7684\u89d2\u8272id\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:userrole:getRolesByUserId"})
    @PostMapping(value={"/getRolesByUserId"})
    public IamSdkApiResponse<List<Long>> getRolesByUserId(@RequestBody Long userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return IamSdkApiResponse.success(Collections.emptyList());
        }
        Long appId = ApplicationUtils.getApplicationId();
        List roles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)roles)) {
            return IamSdkApiResponse.success(Collections.emptyList());
        }
        List roleIds = roles.stream().map(SysRoles::getId).collect(Collectors.toList());
        List userRoles = this.sysUserRoleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).in(SysUserRole::getGrantedRole, roleIds)).eq(SysUserRole::getAdminOption, (Object)"1"));
        List result = userRoles.stream().map(SysUserRole::getGrantedRole).distinct().collect(Collectors.toList());
        return IamSdkApiResponse.success(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5728\u5f53\u524d\u5e94\u7528\u4e0b\u7684\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\u5217\u8868", notes="\u83b7\u53d6\u7528\u6237\u5728\u5f53\u524d\u5e94\u7528\u4e0b\u7684\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\u5217\u8868")
    @AuditLog(moduleName="\u7528\u6237\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u7528\u6237\u5728\u5f53\u524d\u5e94\u7528\u4e0b\u7684\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:userrole:getByUserId"})
    @PostMapping(value={"/getByUserId"})
    public IamSdkApiResponse<List<SysUserRole>> getByUserId(@RequestBody Long userId) {
        Long appId = ApplicationUtils.getApplicationId();
        List roles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)roles)) {
            return IamSdkApiResponse.success(Collections.emptyList());
        }
        List roleIds = roles.stream().map(SysRoles::getId).collect(Collectors.toList());
        List userRoles = this.sysUserRoleService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)"1")).in(SysUserRole::getGrantedRole, roleIds));
        return IamSdkApiResponse.success((Object)userRoles);
    }

    @ApiOperation(value="\u65b0\u589e/\u5220\u9664\u7528\u6237\u5f00\u53d1\u8005\u89d2\u8272\u5173\u8054\u5173\u7cfb", notes="\u65b0\u589e/\u5220\u9664\u7528\u6237\u5f00\u53d1\u8005\u89d2\u8272\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u7528\u6237\u89d2\u8272\u5bf9\u5916\u63a5\u53e3", eventDesc="\u65b0\u589e/\u5220\u9664\u7528\u6237\u5f00\u53d1\u8005\u89d2\u8272\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:userrole:addOrDelAppDevRoleUser"})
    @PostMapping(value={"/addOrDelAppDevRoleUser"})
    public IamSdkApiResponse<Boolean> addOrDelAppDevRoleUser(@RequestBody RoleUserDto roleUserDto) {
        return IamSdkApiResponse.success((Object)this.sysRolesExternalService.addOrDelAppDevRoleUser(roleUserDto).getData());
    }
}

