/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.permission;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryRoleResourceDto;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/roleResource"})
@Api(tags={"\u89d2\u8272\u8d44\u6e90\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseRoleResourceSdkController {
    @Autowired
    private ISysRoleResourceService sysRoleResourceService;

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb", notes="\u6279\u91cf\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u89d2\u8272\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6279\u91cf\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:roleResource:saveBatch"})
    @PostMapping(value={"/saveBatch"})
    public IamSdkApiResponse<Boolean> saveBatch(@RequestBody List<SysRoleResource> sysRoleResources) {
        return IamSdkApiResponse.success((Object)this.sysRoleResourceService.saveBatch(sysRoleResources));
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb\u5217\u8868", notes="\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb\u5217\u8868")
    @AuditLog(moduleName="\u89d2\u8272\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:roleResource:list"})
    @PostMapping(value={"/list"})
    public IamSdkApiResponse<List<SysRoleResource>> list(@RequestBody IamQueryRoleResourceDto iamQueryRoleResourceDto) {
        Long resId = iamQueryRoleResourceDto.getResourceId();
        String relationSource = iamQueryRoleResourceDto.getRelationSource();
        List sysRoleResources = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resId)).eq(SysRoleResource::getRelationSource, (Object)relationSource));
        return IamSdkApiResponse.success((Object)sysRoleResources);
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb", notes="\u6839\u636e\u89d2\u8272id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb")
    @AuditLog(moduleName="\u89d2\u8272\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u89d2\u8272id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:roleResource:listByRoleIds"})
    @PostMapping(value={"/listByRoleIds"})
    public IamSdkApiResponse<List<SysRoleResource>> listByRoleIds(@RequestBody List<Long> roleIds) {
        List sysRoleResources = this.sysRoleResourceService.list((Wrapper)new LambdaQueryWrapper().in(SysRoleResource::getRoleId, roleIds));
        return IamSdkApiResponse.success((Object)sysRoleResources);
    }
}

