/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.permission;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryFunctionModuleDto;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/function"})
@Api(tags={"\u529f\u80fd\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseFunctionSdkController {
    @Autowired
    private ISysFunctionsService sysFunctionsService;
    @Autowired
    private ISysFunctionModulesService sysFunctionModulesService;

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u529f\u80fd", notes="\u6839\u636eid\u67e5\u8be2\u529f\u80fd")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636eid\u67e5\u8be2\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getById"})
    @PostMapping(value={"/getById"})
    public IamSdkApiResponse<SysFunctions> getById(@RequestBody Long id) {
        return IamSdkApiResponse.success((Object)this.sysFunctionsService.getById((Serializable)id));
    }

    @ApiOperation(value="\u66f4\u65b0\u529f\u80fd", notes="\u66f4\u65b0\u529f\u80fd")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u66f4\u65b0\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:function:updateById"})
    @PostMapping(value={"/updateById"})
    public IamSdkApiResponse<Boolean> updateById(@RequestBody SysFunctions sysFunctions) {
        return IamSdkApiResponse.success((Object)this.sysFunctionsService.updateById((Object)sysFunctions));
    }

    @ApiOperation(value="\u4fdd\u5b58\u529f\u80fd", notes="\u4fdd\u5b58\u529f\u80fd")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:function:save"})
    @PostMapping(value={"/save"})
    public IamSdkApiResponse<Boolean> save(@RequestBody SysFunctions sysFunctions) {
        sysFunctions.setApplicationId(ApplicationUtils.getApplicationId());
        return IamSdkApiResponse.success((Object)this.sysFunctionsService.save((Object)sysFunctions));
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u4e0b\u529f\u80fd\u7684\u6700\u5927\u6392\u5e8f\u7f16\u53f7", notes="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u4e0b\u529f\u80fd\u7684\u6700\u5927\u6392\u5e8f\u7f16\u53f7")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u4e0b\u529f\u80fd\u7684\u6700\u5927\u6392\u5e8f\u7f16\u53f7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getMaxOrderByParentId"})
    @PostMapping(value={"/getMaxOrderByParentId"})
    public IamSdkApiResponse<Integer> getMaxOrderByParentId(@RequestBody Long moduleId) {
        Integer order = this.sysFunctionsService.getMaxOrderByParentId(moduleId);
        if (HussarUtils.isEmpty((Object)order)) {
            order = 1;
        }
        return IamSdkApiResponse.success((Object)order);
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u4e0b\u529f\u80fd\u6a21\u5757\u5217\u8868", notes="\u67e5\u8be2\u5e94\u7528\u4e0b\u529f\u80fd\u6a21\u5757\u5217\u8868")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u67e5\u8be2\u5e94\u7528\u4e0b\u529f\u80fd\u6a21\u5757\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:moduleList"})
    @PostMapping(value={"/moduleList"})
    public IamSdkApiResponse<List<SysFunctionModules>> moduleList(@RequestBody IamQueryFunctionModuleDto iamQueryFunctionModuleDto) {
        String moduleName = iamQueryFunctionModuleDto.getModuleName();
        Long parentModuleId = iamQueryFunctionModuleDto.getParentModuleId();
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.sysFunctionModulesService.listByNameAndParentId(moduleName, parentModuleId, appId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u4fe1\u606f", notes="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u4fe1\u606f")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"iamBaseSdk:function:saveModule"})
    @PostMapping(value={"/saveModule"})
    public IamSdkApiResponse<Boolean> saveModule(@RequestBody SysFunctionModules sysFunctionModules) {
        sysFunctionModules.setApplicationId(ApplicationUtils.getApplicationId());
        return IamSdkApiResponse.success((Object)this.sysFunctionModulesService.save((Object)sysFunctionModules));
    }

    @ApiOperation(value="\u83b7\u53d6\u540c\u5e94\u7528\u4e0b\u529f\u80fd\u6a21\u5757\u4e0b\u6a21\u5757\u6700\u5927\u6392\u5e8f\u503c", notes="\u83b7\u53d6\u540c\u5e94\u7528\u4e0b\u529f\u80fd\u6a21\u5757\u4e0b\u6a21\u5757\u6700\u5927\u6392\u5e8f\u503c")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u540c\u5e94\u7528\u4e0b\u529f\u80fd\u6a21\u5757\u4e0b\u6a21\u5757\u6700\u5927\u6392\u5e8f\u503c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getMaxOrderByParentIdAndAppId"})
    @PostMapping(value={"/getMaxOrderByParentIdAndAppId"})
    public IamSdkApiResponse<Integer> getMaxOrderByParentIdAndAppId(@RequestBody Long moduleId) {
        Long appId = ApplicationUtils.getApplicationId();
        Integer order = this.sysFunctionModulesService.getMaxOrderByParentIdAndAppId(moduleId, appId);
        if (HussarUtils.isEmpty((Object)order)) {
            order = 1;
        }
        return IamSdkApiResponse.success((Object)order);
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811", notes="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getFuncModuleTreeForOrg"})
    @PostMapping(value={"/getFuncModuleTreeForOrg"})
    public IamSdkApiResponse<List<JSTreeModel>> getFuncModuleMergeTreeForOrg(@RequestBody(required=false) String functionFlag) {
        Long appId = ApplicationUtils.getApplicationId();
        List funcModuleTree = this.sysFunctionModulesService.loadFuncModuleTree(functionFlag, appId);
        List iamJsTreeModels = JSON.parseArray((String)JSON.toJSONString((Object)funcModuleTree), JSTreeModel.class);
        return IamSdkApiResponse.success((Object)iamJsTreeModels);
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fdid\u96c6\u5408\u83b7\u53d6\u529f\u80fd\u4fe1\u606f", notes="\u6839\u636e\u529f\u80fdid\u96c6\u5408\u83b7\u53d6\u529f\u80fd\u4fe1\u606f")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fdid\u96c6\u5408\u83b7\u53d6\u529f\u80fd\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:listByIds"})
    @PostMapping(value={"/listByIds"})
    public IamSdkApiResponse<List<SysFunctions>> listByIds(@RequestBody List<Long> idList) {
        return IamSdkApiResponse.success((Object)this.sysFunctionsService.listByIds(idList));
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fdid\u83b7\u53d6\u529f\u80fd\u4fe1\u606f\u53ca\u5176\u4e0a\u7ea7\u6a21\u5757\u540d\u79f0\u548c\u529f\u80fd\u5165\u53e3\u8d44\u6e90\u540d\u79f0)", notes="\u6839\u636e\u529f\u80fdid\u83b7\u53d6\u529f\u80fd\u4fe1\u606f\u53ca\u5176\u4e0a\u7ea7\u6a21\u5757\u540d\u79f0\u548c\u529f\u80fd\u5165\u53e3\u8d44\u6e90\u540d\u79f0")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fdid\u83b7\u53d6\u529f\u80fd\u4fe1\u606f\u53ca\u5176\u4e0a\u7ea7\u6a21\u5757\u540d\u79f0\u548c\u529f\u80fd\u5165\u53e3\u8d44\u6e90\u540d\u79f0", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getFunctionDetail"})
    @PostMapping(value={"/getFunctionDetail"})
    public IamSdkApiResponse<SysModuleFunctionsVo> getFunctionDetail(@RequestBody(required=false) Long functionId) {
        return IamSdkApiResponse.success((Object)this.sysFunctionsService.getFunctionDetail(functionId));
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u5757\u540d\u79f0\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u529f\u80fd\u6a21\u5757\u7684\u5168\u8def\u5f84", notes="\u6839\u636e\u6a21\u5757\u540d\u79f0\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u529f\u80fd\u6a21\u5757\u7684\u5168\u8def\u5f84")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u6a21\u5757\u540d\u79f0\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u529f\u80fd\u6a21\u5757\u7684\u5168\u8def\u5f84", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getFullModuleNameMapByName"})
    @PostMapping(value={"/getFullModuleNameMapByName"})
    public IamSdkApiResponse<Map<Long, String>> getFullModuleNameMapByName(@RequestBody String moduleName) {
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.sysFunctionModulesService.getFullModuleNameMapByName(moduleName, appId));
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u5757id\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u7684\u5168\u8def\u5f84", notes="\u6839\u636e\u6a21\u5757id\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u7684\u5168\u8def\u5f84")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u6a21\u5757id\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u7684\u5168\u8def\u5f84", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getFullModuleNameById"})
    @PostMapping(value={"/getFullModuleNameById"})
    public IamSdkApiResponse<String> getFullModuleNameById(@RequestBody Long moduleId) {
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((String)this.sysFunctionModulesService.getFullModuleNameById(moduleId, appId));
    }

    @ApiOperation(value="\u83b7\u53d6\u62e5\u6709\u529f\u80fd\u5165\u53e3\u7684\u529f\u80fd", notes="\u83b7\u53d6\u62e5\u6709\u529f\u80fd\u5165\u53e3\u7684\u529f\u80fd")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u62e5\u6709\u529f\u80fd\u5165\u53e3\u7684\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getFunsByAllDefaultRes"})
    @PostMapping(value={"/getFunsByAllDefaultRes"})
    public IamSdkApiResponse<List<SysFunctions>> getFunsByAllDefaultRes() {
        Long appId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.sysFunctionsService.getFunsByAllDefaultRes(appId));
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fd\u6a21\u5757id\u4fee\u6539\u529f\u80fd\u6a21\u5757", notes="\u6839\u636e\u529f\u80fd\u6a21\u5757id\u4fee\u6539\u529f\u80fd\u6a21\u5757")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fd\u6a21\u5757id\u4fee\u6539\u529f\u80fd\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"iamBaseSdk:function:updateModule"})
    @PostMapping(value={"/updateModule"})
    public IamSdkApiResponse<Boolean> updateModule(@RequestBody SysFunctionModules SysFunctionModules2) {
        return IamSdkApiResponse.success((Object)this.sysFunctionModulesService.updateById((Object)SysFunctionModules2));
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fd\u6a21\u5757id\u83b7\u53d6\u529f\u80fd\u6a21\u5757", notes="\u6839\u636e\u529f\u80fd\u6a21\u5757id\u83b7\u53d6\u529f\u80fd\u6a21\u5757")
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fd\u6a21\u5757id\u83b7\u53d6\u529f\u80fd\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:function:getModuleByModuleId"})
    @PostMapping(value={"/getModuleByModuleId"})
    public IamSdkApiResponse<SysFunctionModules> getModuleByModuleId(@RequestBody Long moduleId) {
        return IamSdkApiResponse.success((Object)this.sysFunctionModulesService.getById((Serializable)moduleId));
    }
}

