/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.identity;

import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamDataScopeDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryDeptIdsDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.service.identity.IamSdkDataScopeService;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeInfo;
import com.jxdinfo.hussar.support.datascope.core.support.service.base.DataScopeService;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/datascope"})
@Api(tags={"\u6570\u636e\u6743\u9650\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseDataScopeSdkController {
    @Resource
    private DataScopeService dataScopeService;
    @Resource
    private IamSdkDataScopeService iamSdkDataScopeService;

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6743\u9650", notes="\u83b7\u53d6\u6570\u636e\u6743\u9650")
    @AuditLog(moduleName="\u6570\u636e\u6743\u9650\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u6570\u636e\u6743\u9650", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:dataScope:getDataScope"})
    @PostMapping(value={"/getDataScope"})
    public IamSdkApiResponse<List<DataScopeInfo>> getDataScope(@RequestBody IamDataScopeDTO dataScopeDTO) {
        List dataScopeInfos = this.iamSdkDataScopeService.getDataScope(dataScopeDTO.getUserId(), dataScopeDTO.getRoleIds(), dataScopeDTO.getMapper(), dataScopeDTO.getServerName());
        return IamSdkApiResponse.success((Object)dataScopeInfos);
    }

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8id", notes="\u83b7\u53d6\u90e8\u95e8id")
    @AuditLog(moduleName="\u6570\u636e\u6743\u9650\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u90e8\u95e8id", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:dataScope:getDeptIds"})
    @PostMapping(value={"/getDeptIds"})
    public IamSdkApiResponse<List<Long>> getDeptIds(@RequestBody IamQueryDeptIdsDTO queryDeptIdsDTO) {
        return IamSdkApiResponse.success((Object)this.dataScopeService.getDeptIds(queryDeptIdsDTO.getType(), queryDeptIdsDTO.getUserId()));
    }
}

