/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.server.controller.authentication;

import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.SysAuthClientDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.service.authentication.IHussarBaseSysAuthClientModelService;
import com.jxdinfo.hussar.iam.common.api.response.IamSdkApiResponse;
import com.jxdinfo.hussar.iam.common.server.util.ApplicationUtils;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.support.apimanager.core.support.model.ScopePermissionModel;
import com.jxdinfo.hussar.support.apimanager.core.support.service.ScopePermissionService;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/sdk/hussarBase/client"})
@Api(tags={"\u529f\u80fd\u8d44\u6e90\u5bf9\u5916\u63a5\u53e3"})
public class HussarBaseSysAuthClientModelController {
    @Resource
    private IHussarBaseSysAuthClientModelService clientModelService;
    @Resource
    private ScopePermissionService scopePermissionService;

    @ApiOperation(value="\u83b7\u53d6\u5ba2\u6237\u7aef\u4fe1\u606f", notes="\u83b7\u53d6\u5ba2\u6237\u7aef\u4fe1\u606f")
    @AuditLog(moduleName="\u8ba4\u8bc1", eventDesc="\u83b7\u53d6\u5ba2\u6237\u7aef\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/getOne"})
    public IamSdkApiResponse<SysAuthClientModel> getOne(@RequestBody SysAuthClientDTO sysAuthClientDTO) {
        String clientId = sysAuthClientDTO.getClientId();
        Long applicationId = ApplicationUtils.getApplicationId();
        return IamSdkApiResponse.success((Object)this.clientModelService.getClientModelByClientId(clientId, applicationId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5ba2\u6237\u7aef\u4fe1\u606f", notes="\u83b7\u53d6\u5ba2\u6237\u7aef\u4fe1\u606f")
    @AuditLog(moduleName="\u8ba4\u8bc1", eventDesc="\u83b7\u53d6\u5ba2\u6237\u7aef\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/getByClientId"})
    public IamSdkApiResponse<ClientModelDetails> getByClientId(@RequestBody SysAuthClientDTO sysAuthClientDTO) {
        String clientId = sysAuthClientDTO.getClientId();
        Long applicationId = ApplicationUtils.getApplicationId();
        ClientModelDetails clientModelDetails = this.clientModelService.getClientDetailByClientID(clientId, applicationId);
        return IamSdkApiResponse.success((Object)clientModelDetails);
    }

    @ApiOperation(value="\u83b7\u53d6\u6743\u9650\u5217\u8868", notes="\u83b7\u53d6\u6743\u9650\u5217\u8868")
    @AuditLog(moduleName="\u5ba2\u6237\u6743\u9650\u5bf9\u5916\u63a5\u53e3", eventDesc="\u83b7\u53d6\u6743\u9650\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"iamBaseSdk:client:getPermissionList"})
    @PostMapping(value={"/getPermissionList"})
    public IamSdkApiResponse<List<String>> getPermissionList(@RequestBody ScopePermissionModel scopePermissionModel) {
        List permissionList = this.scopePermissionService.getPermissionList(scopePermissionModel);
        return IamSdkApiResponse.success((Object)permissionList);
    }
}

