/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.iam.base.sdk.http.service.permission;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeIamDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.iam.base.sdk.api.dto.IamQueryRoleDTO;
import com.jxdinfo.hussar.iam.base.sdk.api.enums.SdkUrlEnum;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.base.sdk.api.treemodel.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.iam.base.sdk.api.vo.WorkTempRoleSearchVo;
import com.jxdinfo.hussar.iam.base.sdk.http.utils.SdkHttpUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseRoleService {
    public List<JSTreeModel> getLazyRoleTree(Long nodeId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_LAZY_ROLE_TREE, (Object)nodeId, new TypeReference<List<JSTreeModel>>(){});
    }

    public List<SysRoles> listByIds(Collection<? extends Serializable> idList) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_LIST_BY_IDS, idList, new TypeReference<List<SysRoles>>(){});
    }

    public List<Long> getRoleIdByRoleName(List<String> roleNames) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_ID_BY_NAME, roleNames, new TypeReference<List<Long>>(){});
    }

    public Long addAppDevRole(String appName) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_ADD_APP_DEV_ROLE, (Object)appName, Long.class);
    }

    public List<Long> getRoleIdByGroupId(List<String> groupNames) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_ID_BY_GROUP_ID, groupNames, new TypeReference<List<Long>>(){});
    }

    public void deleteDevelopRole(Long roleId) {
        SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_DELETE_DEVELOP_ROLE, (Object)roleId, Void.class);
    }

    public List<RoleVo> getRoleInfoByIds(List<Long> roleIds) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_INFO_BY_IDS, roleIds, new TypeReference<List<RoleVo>>(){});
    }

    public List<JSTreeModel> loadRoleGruopTree(Long appId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_LOAD_ROLE_GROUP_TREE, (Object)appId, new TypeReference<List<JSTreeModel>>(){});
    }

    public List<SysRoles> searchRoleToGroup(Long groupId, String roleName) {
        IamQueryRoleDTO queryRoleDTO = new IamQueryRoleDTO();
        queryRoleDTO.setRoleGroupId(groupId);
        queryRoleDTO.setRoleName(roleName);
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_SEARCH_ROLE_TO_GROUP, (Object)queryRoleDTO, new TypeReference<List<SysRoles>>(){});
    }

    public List<ReadOnlyRoleTreeVo> getRoleTree() {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_TREE, null, new TypeReference<List<ReadOnlyRoleTreeVo>>(){});
    }

    public List<WorkTempRoleSearchVo> roleSearch(String roleName) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_ROLE_SEARCH, (Object)roleName, new TypeReference<List<WorkTempRoleSearchVo>>(){});
    }

    public RoleInfoVO getRoleViewMap(Long roleId) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_VIEW_MAP, (Object)roleId, RoleInfoVO.class);
    }

    public Boolean updateRole(SysRoles updateRole) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_UPDATE_ROLE, (Object)updateRole, Boolean.class);
    }

    public List<SysRoles> getRolesByIds(List<Long> roleIds) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLES_BY_IDS, roleIds, new TypeReference<List<SysRoles>>(){});
    }

    public List<SysRoles> getAllRoles() {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ALL_ROLES, null, new TypeReference<List<SysRoles>>(){});
    }

    public Boolean saveRoleBatch(List<SysRoles> roleList) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_SAVE_ROLE_BATCH, roleList, Boolean.class);
    }

    public List<SysRoleGroup> selectRoleGroupByIds(List<Long> roleGroupIds) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_SELECT_ROLE_GROUP_BY_IDS, roleGroupIds, new TypeReference<List<SysRoleGroup>>(){});
    }

    public List<SysRoleGroup> getAllRoleGroup() {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ALL_ROLE_GROUP, null, new TypeReference<List<SysRoleGroup>>(){});
    }

    public Boolean saveRoleGroupBatch(List<SysRoleGroup> roleGroupList) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_SAVE_ROLE_GROUP_BATCH, roleGroupList, Boolean.class);
    }

    public List<ReadOnlyRoleTreeVo> getRoleTreeForSys(RoleTreeIamDto roleTreeIamDto) {
        return SdkHttpUtils.postHttp(SdkUrlEnum.HUSSAR_BASE_GET_ROLE_TREE_FOR_SYS, (Object)roleTreeIamDto, new TypeReference<List<ReadOnlyRoleTreeVo>>(){});
    }
}

