/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleData;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.htsz.extend.permit.dto.DelUserRoleDto;
import com.jxdinfo.hussar.htsz.extend.permit.service.IHussarBaseUserRoleBoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseUserRoleBoServiceImpl
implements IHussarBaseUserRoleBoService {
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;

    public Boolean save(SysUserRole sysUserRole) {
        return this.sysUserRoleService.save((Object)sysUserRole);
    }

    public Boolean update(SysUserRole sysUserRole) {
        return this.sysUserRoleService.update((Object)sysUserRole, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUserRole.getUserId())).eq(SysUserRole::getGrantedRole, (Object)sysUserRole.getGrantedRole()));
    }

    public Boolean saveBatch(Collection<SysUserRole> entityList) {
        return this.sysUserRoleService.saveBatch(entityList);
    }

    public Boolean saveBatchSize(Collection<SysUserRole> entityList) {
        return this.sysUserRoleService.saveBatch(entityList, entityList.size());
    }

    public Boolean saveBatchAudit(Collection<SysUserroleAudit> entityList) {
        return this.sysUserroleAuditService.saveBatch(entityList);
    }

    public Boolean removeByUserId(Long userId) {
        return this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
    }

    public Boolean removeAuditByUserId(Long userId) {
        return this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)userId));
    }

    public List<SysUserRole> listByUserId(Long userId) {
        return this.sysUserRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
    }

    public List<SysUserroleAudit> listAuditByUserId(Long userId) {
        return this.sysUserroleAuditMapper.getHasReviewList(userId);
    }

    public void delUserRoleByRoleId(DelUserRoleDto delUserRoleDto) {
        Long userId = delUserRoleDto.getUserId();
        List roleIds = delUserRoleDto.getRoleIds();
        this.sysUserRoleMapper.delUserRoleByRoleId(userId, roleIds);
    }

    public void delSysRolesByUserId(DelUserRoleDto delUserRoleDto) {
        Long userId = delUserRoleDto.getUserId();
        List roleIds = delUserRoleDto.getRoleIds();
        this.sysUserRoleMapper.delSysRolesByUserId(userId, roleIds);
    }

    public List<Long> getUserRole(Long roleId) {
        return this.sysUserRoleMapper.getUserRole(roleId);
    }

    public List<SysUserRole> selectList(Long userId) {
        return this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)UserStatus.OK.getCode()));
    }

    public int delete(Long id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)id)).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.GRADEADMIN_ROLE.getValue());
        return this.sysUserRoleMapper.delete((Wrapper)wrapper);
    }

    public int deleteById(Long id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)id);
        return this.sysUserRoleMapper.delete((Wrapper)wrapper);
    }

    public int insert(SysUserRole sysUserRole) {
        return this.sysUserRoleMapper.insert((Object)sysUserRole);
    }

    public List<Long> delOrganRoleIdByUserId(Long userId) {
        return this.sysUserRoleMapper.delOrganRoleIdByUserId(userId);
    }

    public List<String> getSysRolesByUserId(Long userId) {
        return this.sysUserRoleMapper.getSysRolesByUserId(userId);
    }

    public List<SysUserRole> getUserRolesByUserIds(List<Long> userIds) {
        return this.sysUserRoleService.getUserRolesByUserIds(userIds);
    }

    public Map<String, Integer> saveOrUpdateBatchUserRoles(List<SysUserRole> userRoles) {
        return this.sysUserRoleService.saveOrUpdateBatchUserRoles(userRoles);
    }

    public Boolean removeByUserIds(List<Long> userIds) {
        if (ToolUtil.isNotEmpty(userIds)) {
            return this.sysUserRoleService.remove((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUserRole::getUserId, userIds));
        }
        return true;
    }

    @HussarDs(value="#connName")
    public String hasRole(Long userId, Long roleId, String connName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getAdminOption, (Object)"1");
        long count = this.sysUserRoleService.count((Wrapper)wrapper);
        return count > 0L ? "true" : "false";
    }

    public List<RoleData> getCommonUserRoleData(Long id, boolean gradeAdmin) {
        return this.sysUserRoleMapper.getCommonUserRoleData(id, gradeAdmin);
    }

    public List<Long> getRolesByUserId(Long userId) {
        return this.sysUserRoleService.getRolesByUserId(userId);
    }
}

