/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.service.impl;

import com.alibaba.nacos.shaded.com.google.common.collect.ImmutableMap;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service
public class HelpDocDownloadService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpDocDownloadService.class);
    private static final Map<Boolean, String> HELP_DOC_PATH_MAP = ImmutableMap.of((Object)true, (Object)"doc/admin", (Object)false, (Object)"doc/user");
    @Autowired
    private OssProperties ossProperties;

    public String getFileDownloadUrl(HttpServletResponse response, Boolean isAdmin) {
        String fileName;
        try {
            String resourcePath = "classpath:" + HELP_DOC_PATH_MAP.get(isAdmin) + "/*";
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources(resourcePath);
            if (resources.length == 0) {
                throw new FileNotFoundException("No files found in " + resourcePath);
            }
            Resource resource = resources[0];
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(resource.getInputStream(), 10240);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int len;
                fileName = URLEncoder.encode(Objects.requireNonNull(resource.getFilename()), "UTF-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                response.setContentType("multipart/form-data");
                response.setContentLengthLong(resource.contentLength());
                byte[] buff = new byte[this.ossProperties.getDownloadBuffSize()];
                while ((len = ((InputStream)bufferedInputStream).read(buff)) > 0) {
                    bufferedOutputStream.write(buff, 0, len);
                    bufferedOutputStream.flush();
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u7f16\u7801\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        catch (IOException e) {
            LOGGER.error("IO\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        return fileName;
    }
}

