/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.organ.service.impl;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.handler.LogObjectHolder;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.htsz.extend.organ.dao.SysPostStruMapper;
import com.jxdinfo.hussar.htsz.extend.organ.model.SysPostStru;
import com.jxdinfo.hussar.htsz.extend.organ.service.IHussarBaseSysPostStruService;
import com.jxdinfo.hussar.htsz.extend.organ.service.ISysPostStruService;
import com.jxdinfo.hussar.htsz.extend.organ.service.ITenantPostChooseStruTree;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseSysPostStruServiceImpl
implements IHussarBaseSysPostStruService {
    @Resource
    private SysPostStruMapper sysPostStruMapper;
    @Resource
    private ISysPostStruService postStruService;
    @Resource
    private ITenantPostChooseStruTree tenantPostChooseStruTree;

    public List<JSTreeModel> getOrgTreeVue(Map<String, Object> map) {
        Long parentId;
        Long newParentId = parentId = map.get("parentId") == null ? null : Long.valueOf(Long.parseLong(map.get("parentId").toString()));
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setText("\u53d1\u6587\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("isRoot");
        if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
            newParentId = Constants.ROOT_NODE_ID;
            result.add(root);
        }
        List<JSTreeModel> list1 = this.sysPostStruMapper.getLazyPostStruTree(newParentId);
        for (JSTreeModel jsTreeModel : list1) {
            jsTreeModel.setType("1");
        }
        result.addAll(list1);
        return result;
    }

    public String savePostStru(Map<String, Object> map) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SysPostStru sysPostStru = new SysPostStru();
        sysPostStru.setStruId(null);
        sysPostStru.setParentId(map.get("parentId") == null ? null : Long.valueOf(Long.parseLong(map.get("parentId").toString())));
        sysPostStru.setOrganName(map.get("organName") == null ? null : map.get("organName").toString());
        sysPostStru.setInUse(map.get("inUse") == null ? null : map.get("inUse").toString());
        sysPostStru.setSeq(new BigDecimal(map.get("seq") == null ? "" : map.get("seq").toString()));
        boolean flag = this.postStruService.save((Object)sysPostStru);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        return "\u65b0\u589e\u6210\u529f";
    }

    public String orgInfoEditSave(Map<String, Object> map) {
        String organName = map.get("organName") == null ? null : map.get("organName").toString();
        String inUse = map.get("inUse") == null ? null : map.get("inUse").toString();
        String seq = map.get("seq") == null ? null : map.get("seq").toString();
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.set(SysPostStru::getOrganName, (Object)organName)).set(SysPostStru::getSeq, (Object)new BigDecimal(seq))).set(SysPostStru::getInUse, (Object)new BigDecimal(inUse))).eq(SysPostStru::getStruId, (Object)struId);
        boolean flag = this.postStruService.update((Wrapper)lambdaUpdateWrapper);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return "\u66f4\u65b0\u6210\u529f";
    }

    public String delOrgById(Map<String, Object> map) {
        Long struId = map.get("struId") == null ? null : Long.valueOf(Long.parseLong(map.get("struId").toString()));
        SysPostStru sysPostStru = (SysPostStru)this.postStruService.getById((Serializable)struId);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("organName", sysPostStru.getOrganName());
        LogObjectHolder.me().set("edit_object_after", map1);
        ArrayList<Long> struIdList = new ArrayList<Long>();
        struIdList.add(struId);
        this.getChildrenStruId(struIdList, struId);
        int num = this.sysPostStruMapper.deleteBatchIds(struIdList);
        if (num == 0) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return "\u5220\u9664\u6210\u529f";
    }

    public SysPostStru orgInfoEdit(Map<String, String> map) {
        String struId = map.get("struId");
        SysPostStru sysPostStru = (SysPostStru)this.postStruService.getById((Serializable)((Object)struId));
        if (sysPostStru.getParentName() == null) {
            sysPostStru.setParentName("\u53d1\u6587\u673a\u6784");
        }
        return sysPostStru;
    }

    public SysPostStru orgInfo(Map<String, String> map) {
        String struId = map.get("struId");
        SysPostStru sysPostStru = (SysPostStru)this.postStruService.getById((Serializable)((Object)struId));
        if (sysPostStru.getParentName() == null) {
            sysPostStru.setParentName("\u53d1\u6587\u673a\u6784");
        }
        return sysPostStru;
    }

    public List<JSTreeModel> getChooseStruTree(Map<String, String> map) {
        HussarTenantDefinition tenant;
        String label = map.get("label") == null ? null : map.get("label");
        Long parentId = map.get("struId") == null ? 11L : Long.parseLong(map.get("struId"));
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setText("\u53d1\u6587\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("isRoot");
        String connName = "master";
        if ("platformLevel".equals(label)) {
            connName = "master";
        } else if ("factoryLevel".equals(label) && HussarUtils.isNotEmpty((Object)(tenant = HussarContextHolder.getHussarTenant()))) {
            connName = tenant.getConnName();
        }
        if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentId)) {
            result.add(root);
            return result;
        }
        List list = this.tenantPostChooseStruTree.getPostStruTree(connName, parentId);
        result.addAll(list);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSTreeModel> getSpecialChooseStruTree(String label, String orgName) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setText("\u53d1\u6587\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("isRoot");
        result.add(root);
        try {
            List<JSTreeModel> orgList;
            if ("platformLevel".equals(label)) {
                DynamicDataSourceContextHolder.push((String)"master");
            } else if ("factoryLevel".equals(label)) {
                SecurityUser user = BaseSecurityUtil.getUser();
                DynamicDataSourceContextHolder.push((String)user.getConnName());
            }
            List<JSTreeModel> allList = this.sysPostStruMapper.getPostStruTree(null);
            if (allList.size() > 0 && (orgList = allList.stream().filter(item -> item.getText().contains(orgName)).collect(Collectors.toList())).size() > 0) {
                orgList.forEach(org -> {
                    StringBuilder parentName = new StringBuilder();
                    this.getTreeParentNames(allList, org.getParent(), parentName);
                    org.setText(org.getText() + "(" + parentName.toString() + ")");
                    org.setParent(Constants.ROOT_NODE_ID);
                });
                result.addAll(orgList);
            }
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
        return ForestNodeMerger.merge(result);
    }

    private void getTreeParentNames(List<JSTreeModel> allTreeList, Long struId, StringBuilder parentName) {
        for (JSTreeModel treeNode : allTreeList) {
            if (ToolUtil.isEmpty((Object)treeNode.getParent()) || !struId.equals(treeNode.getId())) continue;
            parentName.append("/" + treeNode.getText());
            this.getTreeParentNames(allTreeList, treeNode.getParent(), parentName);
        }
    }

    private void getChildrenStruId(List<Long> struIds, Long parentId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("PARENT_ID", parentId);
        List sysPostStru = this.sysPostStruMapper.selectByMap(map);
        for (SysPostStru stru : sysPostStru) {
            if (!ToolUtil.isNotEmpty((Object)sysPostStru)) continue;
            struIds.add(stru.getStruId());
            this.getChildrenStruId(struIds, stru.getStruId());
        }
    }
}

