/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.htsz.extend.utils;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.jxdinfo.hussar.common.properties.DataSourceProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class DataSourceUtil {
    private static Logger log = LogManager.getLogger(DataSourceUtil.class);
    private static final String DRUID_FILTERS = "log4j,mergeStat";
    private static final int ERROR_RETRY_ATTEMPTS = 0;
    private static final int MAX_WAIT_TIME = 10000;
    private static final String[] JDBC_DRIVERS;

    @Deprecated
    public static void addDataSource(DataSourceProperty property) {
        DruidConfig druid = property.getDruid();
        druid.setFilters(DRUID_FILTERS);
        druid.setTestWhileIdle(Boolean.valueOf(false));
        druid.setBreakAfterAcquireFailure(Boolean.valueOf(true));
        druid.setFailFast(Boolean.valueOf(true));
        druid.setConnectionErrorRetryAttempts(Integer.valueOf(0));
        druid.setMaxWait(Integer.valueOf(10000));
        druid.setUseUnfairLock(Boolean.valueOf(true));
        property.setDruid(druid);
    }

    public static void addDataSource(DynamicDataSourceDto dynamicDataSourceDto) {
        DynamicDatasourceService dynamicDatasourceService = (DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class);
        dynamicDatasourceService.addDynamicDatasource(dynamicDataSourceDto);
    }

    public static void removeDataSource(String name) {
        DynamicDatasourceService dynamicDatasourceService = (DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class);
        dynamicDatasourceService.removeDynamicDatasource(name);
    }

    @Deprecated
    public static boolean clearDataSource() {
        try {
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static DataSource getDataSource(String name) {
        DynamicDatasourceService dynamicDatasourceService = (DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class);
        return dynamicDatasourceService.getDatasourceByPoolName(name);
    }

    public static DataSource getDataSource() {
        DynamicDatasourceService dynamicDatasourceService = (DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class);
        return dynamicDatasourceService.getCurrentDatasource();
    }

    public static Connection getConnection(String url, String username, String password) throws SQLException {
        if (url.startsWith("jdbc:oscar")) {
            try {
                Class.forName("com.oscar.Driver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return DriverManager.getConnection(url, username, password);
    }

    public static Connection getConnection(String name) throws SQLException {
        return DataSourceUtil.getDataSource(name).getConnection();
    }

    public static Connection getConnection() throws SQLException {
        return DataSourceUtil.getDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createDatabase(Connection conn, DataSourceProperties dbProperties) {
        Statement statement = null;
        try {
            String sql;
            String driverName = conn.getMetaData().getDriverName();
            statement = conn.createStatement();
            if (driverName.toUpperCase().contains("MYSQL")) {
                sql = "CREATE DATABASE IF NOT EXISTS `" + dbProperties.getDbName() + "` CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';";
            } else if (driverName.toUpperCase().contains("OSCAR")) {
                sql = "SET MIN_PASSWORD_LEN = 0 ; CREATE USER \"" + dbProperties.getUsername() + "\" WITH  DEFAULT TABLESPACE SYSTEM PASSWORD '" + dbProperties.getPassword() + "' role RESOURCE;";
            } else if (driverName.toUpperCase().contains("ORACLE")) {
                sql = "BEGIN EXECUTE IMMEDIATE 'CREATE USER " + dbProperties.getUsername() + " IDENTIFIED BY " + dbProperties.getPassword() + " DEFAULT TABLESPACE HUSSAR_V8'; execute immediate 'GRANT CREATE VIEW,CONNECT,RESOURCE TO " + dbProperties.getUsername() + "';end;";
            } else if (driverName.toUpperCase().contains("DM")) {
                sql = "CREATE USER " + dbProperties.getUsername() + " IDENTIFIED BY " + dbProperties.getPassword() + " limit password_life_time 60 default tablespace HUSSAR_V8;";
                statement.executeUpdate(sql);
                sql = "GRANT \"RESOURCE\" to " + dbProperties.getUsername() + ";";
            } else if (driverName.toUpperCase().contains("POSTGRESQL")) {
                sql = "CREATE USER \"" + dbProperties.getUsername() + "\" WITH PASSWORD '" + dbProperties.getPassword() + "'; CREATE DATABASE \"" + dbProperties.getUsername() + "\" OWNER \"" + dbProperties.getUsername() + "\"; GRANT ALL PRIVILEGES ON DATABASE \"" + dbProperties.getUsername() + "\" TO \"" + dbProperties.getUsername() + "\";";
            } else {
                boolean bl = false;
                return bl;
            }
            statement.executeUpdate(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateDbPassword(Connection conn, DataSourceProperties dbProperties) {
        Statement statement = null;
        try {
            String driverName = conn.getMetaData().getDriverName();
            String sql = null;
            statement = conn.createStatement();
            if (driverName.toUpperCase().contains("MYSQL")) {
                boolean bl = true;
                return bl;
            }
            if (driverName.toUpperCase().contains("OSCAR")) {
                sql = "ALTER USER " + dbProperties.getUsername() + " WITH PASSWORD '" + dbProperties.getPassword() + "';";
            } else if (driverName.toUpperCase().contains("ORACLE")) {
                sql = "ALTER USER " + dbProperties.getUsername() + " IDENTIFIED BY " + dbProperties.getPassword() + "";
            } else if (driverName.toUpperCase().contains("DM")) {
                sql = "ALTER USER " + dbProperties.getUsername() + " IDENTIFIED BY " + dbProperties.getPassword() + "";
            } else if (driverName.toUpperCase().contains("POSTGRESQL")) {
                sql = "ALTER USER \"" + dbProperties.getUsername() + "\" WITH PASSWORD '" + dbProperties.getPassword() + "';";
            } else {
                boolean bl = false;
                return bl;
            }
            statement.executeUpdate(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean createDatabase(DataSourceProperty connProperty, DataSourceProperties dbProperties) {
        try {
            Connection connection = DataSourceUtil.getConnection(connProperty.getUrl(), connProperty.getUsername(), connProperty.getPassword());
            return DataSourceUtil.createDatabase(connection, dbProperties);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createDatabase(String name, DataSourceProperties dbProperties) {
        try {
            Connection connection = DataSourceUtil.getConnection(name);
            return DataSourceUtil.createDatabase(connection, dbProperties);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createDatabase(DataSourceProperties dbProperties) {
        try {
            Connection connection = DataSourceUtil.getConnection();
            return DataSourceUtil.createDatabase(connection, dbProperties);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean execSqlFile(Connection conn, String sqlFileName) {
        try {
            Resources.setCharset((Charset)Charset.forName("UTF8"));
            ScriptRunner runner = new ScriptRunner(conn);
            runner.setLogWriter(null);
            runner.setStopOnError(false);
            runner.runScript(Resources.getResourceAsReader((String)sqlFileName));
            runner.closeConnection();
            conn.close();
            return true;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean execSqlFile(DataSourceProperty property, String sqlFileName) {
        try {
            Connection connection = DataSourceUtil.getConnection(property.getUrl(), property.getUsername(), property.getPassword());
            return DataSourceUtil.execSqlFile(connection, sqlFileName);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean execSqlFile(String name, String sqlFileName) {
        try {
            Connection connection = DataSourceUtil.getConnection(name);
            return DataSourceUtil.execSqlFile(connection, sqlFileName);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean execSqlFile(String sqlFileName) {
        try {
            Connection connection = DataSourceUtil.getConnection();
            return DataSourceUtil.execSqlFile(connection, sqlFileName);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String currentDsName() {
        String dsName = null;
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null) {
                dsName = user.getConnName();
            }
        }
        catch (Exception e) {
            dsName = null;
        }
        if (ToolUtil.isEmpty(dsName)) {
            DataSource dataSource = DataSourceUtil.getDataSource();
            if (dataSource instanceof ItemDataSource) {
                return ((ItemDataSource)dataSource).getName();
            }
            return dsName;
        }
        return dsName;
    }

    public static DataSource getDataSourceById(String id) {
        return (DataSource)HussarCacheUtil.get((String)"datasource_conn", (Object)id);
    }

    public static Connection getConnectionById(String id) {
        return (Connection)HussarCacheUtil.get((String)"datasource_conn", (Object)id);
    }

    public static void changeTempDsById(String id) {
        DataSource dataSource = DataSourceUtil.getDataSourceById(id);
        if (!(dataSource instanceof ItemDataSource)) {
            throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684 DataSource \u7c7b\u578b");
        }
        String connName = ((ItemDataSource)dataSource).getName();
        DataSourceUtil.changeTempDs(connName);
    }

    @Deprecated
    public static void changeLongTermDs(String name) {
    }

    public static void changeTempDs(String name) {
        DynamicDataSourceContextHolder.push((String)name);
    }

    public static void poll() {
        DynamicDataSourceContextHolder.poll();
    }

    public static void clear() {
        DynamicDataSourceContextHolder.clear();
    }

    static {
        for (String driver : JDBC_DRIVERS = new String[]{"oracle.jdbc.driver.OracleDriver", "oracle.jdbc.OracleDriver", "com.oscar.Driver", "com.mysql.cj.jdbc.Driver", "org.postgresql.Driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "dm.jdbc.driver.DmDriver", "com.kingbase8.Driver", "com.highgo.jdbc.Driver"}) {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                log.info("\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25: " + driver);
            }
        }
    }
}

