/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.common.controller;

import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarBase/secLevel"})
@Api(tags={"\u5206\u4fdd\u5bc6\u7ea7\u7ba1\u7406"})
public class HussarSecLevelController {
    @Resource
    private OssService ossService;
    @Resource
    private ISysDicRefService sysDicRefService;
    private static String SECURITY_LEVEL = "security_level";

    @GetMapping(value={"/getSecLabelList"})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6id\u83b7\u53d6\u5bc6\u7ea7\u5217\u8868", notes="\u6839\u636e\u6587\u4ef6id\u83b7\u53d6\u5bc6\u7ea7\u5217\u8868")
    @Inner
    public ApiResponse<Map<Long, String>> getSecLabelList(@RequestParam String fileIds) {
        String[] fileIdList = fileIds.split(",");
        List attachList = this.ossService.getByFileIds(fileIdList);
        Map<Long, Integer> secValueList = attachList.stream().filter(attach -> HussarUtils.isNotEmpty((Object)attach.getSecurityLevel())).collect(Collectors.toMap(AttachmentManagerModel::getId, AttachmentManagerModel::getSecurityLevel));
        List secDicList = this.sysDicRefService.getDictByType(SECURITY_LEVEL);
        Map<String, String> secDicMap = secDicList.stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
        HashMap<Long, String> result = new HashMap<Long, String>();
        for (Long fileId : secValueList.keySet()) {
            Integer secValue = secValueList.get(fileId);
            if (!HussarUtils.isNotEmpty((Object)secValue)) continue;
            String label = secDicMap.get(secValue.toString());
            result.put(fileId, label);
        }
        return ApiResponse.success(result);
    }

    @GetMapping(value={"/getSecLabelListInt"})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6id\u83b7\u53d6\u5bc6\u7ea7\u5217\u8868", notes="\u6839\u636e\u6587\u4ef6id\u83b7\u53d6\u5bc6\u7ea7\u5217\u8868")
    @Inner
    public ApiResponse<Map<Long, Integer>> getSecLabelListInt(@RequestParam String fileIds) {
        String[] fileIdList = fileIds.split(",");
        List attachList = this.ossService.getByFileIds(fileIdList);
        Map<Long, Integer> secValueList = attachList.stream().filter(attach -> HussarUtils.isNotEmpty((Object)attach.getSecurityLevel())).collect(Collectors.toMap(AttachmentManagerModel::getId, AttachmentManagerModel::getSecurityLevel));
        return ApiResponse.success(secValueList);
    }
}

