/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.common.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.properties.SwitchUserProperties;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.basic.components.properties.HussarCodeProperties;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.properties.PinyinSynProperties;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.common.properties.UserSignProperties;
import com.jxdinfo.hussar.common.properties.WorkstationConfigProperties;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.general.common.properties.HussarBaseIDCardProperties;
import com.jxdinfo.hussar.general.common.properties.HussarBaseJobProperties;
import com.jxdinfo.hussar.general.common.properties.HussarBaseOauth2SecurityProperties;
import com.jxdinfo.hussar.general.common.properties.HussarBaseSecurityProperties;
import com.jxdinfo.hussar.general.common.properties.HussarExcludeIndexProperties;
import com.jxdinfo.hussar.general.common.properties.HussarHelpConfigProperties;
import com.jxdinfo.hussar.general.common.properties.HussarSecureProperties;
import com.jxdinfo.hussar.general.common.properties.HussarWorkstationVisibleProperties;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.EncryptSupportService;
import com.jxdinfo.hussar.platform.core.support.service.dto.EncryptDto;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.security.core.dto.PasswordEncryptDTO;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/baseData"})
@Api(tags={"\u57fa\u7840\u4fe1\u606f\u7ba1\u7406"})
public class SystemBaseDataControler {
    private static int SM2 = 1;
    private static final Logger logger = LoggerFactory.getLogger(SystemBaseDataControler.class);
    @Resource
    private IGlobalService globalService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private HussarSecureProperties hussarSecureProperties;
    @Resource
    private PasswordEncryptService passwordEncryptService;
    @Resource
    private HussarBaseJobProperties hussarBaseJobProperties;
    @Resource
    private HussarBaseOauth2SecurityProperties hussarBaseOauth2SecurityProperties;
    @Resource
    private HussarBaseSecurityProperties hussarBaseSecurityProperties;
    @Resource
    private MultipartProperties multipartProperties;
    @Resource
    private UserSignProperties userSignProperties;
    @Value(value="${hussar.secure.encrypt.getEnabled:${hussar.secure.encrypt.get-enabled:true}}")
    private Boolean getEncryptEnable;
    @Value(value="${hussar.secure.encrypt.postEnabled:${hussar.secure.encrypt.post-enabled:true}}")
    private Boolean postEncryptEnable;
    @Value(value="${hussar.core.tenant.enabled:false}")
    private Boolean tenantEnabled;
    @Value(value="${hussar.dynamic-table.enable:true}")
    private Boolean dynamicTableEnabled;
    @Value(value="${plugin.runMode:dev}")
    private String active;
    @Value(value="${hussar.workstation.roleIds:1450715195867925063,1450785135866925067}")
    private String editWorkstationRoleIds;
    @Resource
    private PinyinSynProperties pinyinSynProperties;
    @Resource
    private SwitchUserProperties switchUserProperties;
    @Autowired(required=false)
    private EncryptSupportService encryptSupportService;
    @Resource
    private ISysStruService sysStruService;
    @Autowired(required=false)
    private AuditLogProperties auditLogProperties;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Resource
    private IPageViewConfigBoService pageViewConfigBoService;
    @Resource
    private HussarCodeProperties hussarCodeProperties;
    private static String AUTHOR_INTER_ORGAN = "AUTHOR_INTER_ORGAN";
    private static String AUTHOR_EXTER_ORGAN = "AUTHOR_EXTER_ORGAN";
    private static String CONFIG_PREFIX = "hussar.base-config.";
    private static String PASSWORD_DISABLE = "password_disable";
    private static String BACK_PASSWORD_DISABLE = "backPassword_disable";
    private static String EXIT_DISABLE = "exit_disable";
    private static String FUNCTION_AUDIT_ENABLE = "funcAuditEnable";
    private static String RESOURCE_AUDIT_ENABLE = "resAuditEnable";
    private static String TOKEN_NAME = "tokenName";
    private static String NO_LOGO = "nologo";
    private static String PORTAL_URL = "portalUrl";
    private static String HOME_PAGE_INFO = "homePageInfo";
    @Value(value="${plugin.enable:${plugin.enable:false}}")
    private Boolean getPluginEnable;
    @Resource
    private HussarWorkstationVisibleProperties hussarWorkstationVisibleProperties;
    @Resource
    private HussarExcludeIndexProperties hussarExcludeIndexProperties;
    @Resource
    private HussarBaseIDCardProperties hussarBaseIDCardProperties;
    @Resource
    private HussarHelpConfigProperties hussarHelpConfigProperties;
    @Resource
    private ISysAuditConfigService sysAuditConfigService;
    @Resource
    private WorkstationConfigProperties workstationConfigProperties;

    private static int convert(String encryptType) {
        if ("sm2".equalsIgnoreCase(encryptType)) {
            return SM2;
        }
        return 0;
    }

    @GetMapping(value={"/getBaseData"})
    @ApiOperation(value="\u83b7\u53d6\u52a0\u5bc6\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u52a0\u5bc6\u914d\u7f6e\u4fe1\u606f")
    @Inner
    public ApiResponse<Map<String, Object>> getInitEncryptInfo() {
        String isGreyScreenKey;
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean enableEncrypt = this.hussarSecureProperties.getEnabled();
        map.put("enableEncrypt", enableEncrypt);
        map.put("getEnable", this.getEncryptEnable);
        map.put("postEnable", this.postEncryptEnable);
        map.put("h_version", this.hussarConfig.getStaticVersion());
        map.put("tabSwitchover", this.globalService.isTabSwitchover());
        map.put("kaptcha", this.hussarLoginConfigService.getKaptchaOpen());
        map.put("totp", this.hussarLoginConfigService.getTotpOpen());
        map.put("standAlone", this.sysBaseConfigService.isNotRedis());
        map.put("tenantOpen", this.hussarTenantProperties.isEnabled());
        map.put("tenantType", this.hussarTenantProperties.getType());
        map.put("connName", HussarContextHolder.getConnName());
        map.put("headerTokenKey", this.hussarBaseOauth2SecurityProperties.getHeaderTokenKey());
        map.put("allowDisplacement", this.hussarBaseSecurityProperties.getAllowDisplacement());
        map.put("maxFileSize", this.multipartProperties.getMaxFileSize().toBytes());
        map.put("tenantEnabled", this.tenantEnabled);
        map.put("secureAssessment", this.secureAssesmentProperties.isOpen());
        map.put("headerTokenKey", this.hussarBaseOauth2SecurityProperties.getHeaderTokenKey());
        map.put("isEnableLang", TranslateUtil.getIsEnable());
        map.put("switchUserEnable", this.switchUserProperties.getEnable());
        map.put("editWorkstationRoleIds", this.editWorkstationRoleIds);
        map.put("pinyinsyn", this.pinyinSynProperties.isOpen());
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("form_to_form");
        if (HussarUtils.isNotEmpty((Object)baseConfig)) {
            map.put("isShowFormToForm", "0".equals(baseConfig.getConfigValue()));
        }
        SysBaseConfig signHand = this.sysBaseConfigService.getSysBaseConfig("sign_hand");
        map.put("signHand", false);
        if (HussarUtils.isNotEmpty((Object)signHand)) {
            map.put("signHand", "0".equals(signHand.getConfigValue()));
        }
        this.handleEncrypt(enableEncrypt, map);
        map.put("appName", this.hussarBaseJobProperties.getAppName());
        PasswordEncryptDTO pwEncryptDTO = this.passwordEncryptService.getPasswordEncryptInfo();
        boolean enablePwEncryption = pwEncryptDTO.getEnabled();
        map.put("enablePwEncryption", enablePwEncryption);
        if (enablePwEncryption) {
            if (HussarUtils.isBlank((CharSequence)pwEncryptDTO.getEncryptKey())) {
                logger.error("\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u83b7\u53d6\u7684\u5bc6\u7801\u52a0\u5bc6\u79d8\u94a5\u4e3a\u7a7a");
                throw new BaseException(BaseExceptionEnum.SERVER_EXCEPTION.getCode(), TranslateUtil.getTranslateName((String)BaseExceptionEnum.SERVER_EXCEPTION.getMessage()));
            }
            map.put("hussarET", SystemBaseDataControler.convert(pwEncryptDTO.getEncryptType()));
            map.put("hussarEK", pwEncryptDTO.getEncryptKey());
        }
        if (this.sysBaseConfigService.getSysBaseConfig(isGreyScreenKey = "isGreyScreen") != null) {
            SysBaseConfig sysBaseConfig = this.sysBaseConfigService.getSysBaseConfig(isGreyScreenKey);
            boolean isGreyScreen = "1".equals(sysBaseConfig.getConfigValue());
            map.put(isGreyScreenKey, isGreyScreen);
        } else {
            map.put(isGreyScreenKey, false);
        }
        String orgInName = this.sysStruService.getOrganFname(Constants.ROOT_NODE_ID);
        map.put("orgInName", orgInName);
        String orgOutName = this.sysStruService.getOrganFname(Constants.OUT_STRU_NODE_ID);
        map.put("orgOutName", orgOutName);
        map.put("audit", Boolean.FALSE);
        if (HussarUtils.isNotEmpty((Object)this.auditLogProperties)) {
            map.put("audit", this.auditLogProperties.getEnable());
        }
        String environment = "2";
        if ("prod".equals(this.active)) {
            environment = "3";
        } else if ("dev".equals(this.active)) {
            environment = "2";
        }
        map.put("environment", environment);
        SysBaseConfig protectStatus = this.sysBaseConfigService.getSysBaseConfig("protection_status");
        map.put("protection_status", HussarUtils.isNotEmpty((Object)protectStatus) ? protectStatus.getConfigValue() : "1");
        SysBaseConfig organExpend = this.sysBaseConfigService.getSysBaseConfig("is_organ_expend");
        map.put("is_organ_expend", HussarUtils.isNotEmpty((Object)organExpend) ? organExpend.getConfigValue() : "1");
        map.put("pluginEnable", this.getPluginEnable);
        map.put("enableHelpCenter", this.hussarHelpConfigProperties.getEnable());
        map.put("helpCenterUrl", this.hussarHelpConfigProperties.getUrl());
        map.put("isFenBaoEnable", this.protectionStatusConfigBoService.isFenBaoEnable());
        String passwordDisable = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(CONFIG_PREFIX + PASSWORD_DISABLE);
        map.put(PASSWORD_DISABLE, HussarUtils.isNotEmpty((Object)passwordDisable) ? passwordDisable : "0");
        String backPasswordDisable = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(CONFIG_PREFIX + BACK_PASSWORD_DISABLE);
        map.put(BACK_PASSWORD_DISABLE, HussarUtils.isNotEmpty((Object)backPasswordDisable) ? backPasswordDisable : "0");
        String exitDisable = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(CONFIG_PREFIX + EXIT_DISABLE);
        map.put(EXIT_DISABLE, HussarUtils.isNotEmpty((Object)exitDisable) ? exitDisable : "0");
        boolean criticalAuditFlag = this.sysAuditConfigService.isCriticalOperationsAudit();
        if (criticalAuditFlag) {
            map.put(FUNCTION_AUDIT_ENABLE, this.sysAuditConfigService.isFunctionAudit());
            map.put(RESOURCE_AUDIT_ENABLE, this.sysAuditConfigService.isResourceAudit());
        } else {
            map.put(FUNCTION_AUDIT_ENABLE, false);
            map.put(RESOURCE_AUDIT_ENABLE, false);
        }
        map.put("enableConsoleWorkstation", this.hussarWorkstationVisibleProperties.getEnable());
        map.put("consoleWorkstationRoles", this.hussarWorkstationVisibleProperties.getIncludeRoles());
        map.put("excludeIndexRoles", this.hussarExcludeIndexProperties.getExcludeRoles());
        map.put("isIdCardNotEmpty", this.hussarBaseIDCardProperties.getNotEmpty());
        Map homePageInfoObjectNew = this.pageViewConfigBoService.getHomePageInfo();
        map.put(HOME_PAGE_INFO, homePageInfoObjectNew);
        String logo = this.hussarCodeProperties.getLogo();
        if (HussarUtils.isNotEmpty((Object)logo)) {
            JSONObject logoObject = JSON.parseObject((String)logo);
            map.put(TOKEN_NAME, logoObject.getString(TOKEN_NAME));
            map.put(NO_LOGO, logoObject.getBoolean(NO_LOGO));
            map.put(PORTAL_URL, logoObject.getString(PORTAL_URL));
        } else {
            map.put(TOKEN_NAME, "");
            map.put(NO_LOGO, false);
            map.put(PORTAL_URL, "");
        }
        map.put("workstation", this.workstationConfigProperties.getEnable());
        map.put("userSign", this.userSignProperties.getEnable());
        map.put("dynamicTableEnabled", this.dynamicTableEnabled);
        return ApiResponse.success(map);
    }

    private void handleEncrypt(boolean enableEncrypt, Map<String, Object> map) {
        if (enableEncrypt) {
            this.encryptSupportService.initEncryptInfo();
            EncryptDto initEncryptInfo = this.encryptSupportService.getInitEncryptInfo();
            if (HussarUtils.isBlank((CharSequence)initEncryptInfo.getFrontPriKey()) || HussarUtils.isBlank((CharSequence)initEncryptInfo.getBackendPubKey())) {
                logger.error("\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u83b7\u53d6\u7684\u4f20\u8f93\u52a0\u5bc6\u79d8\u94a5\u4e3a\u7a7a");
                throw new BaseException(BaseExceptionEnum.SERVER_EXCEPTION.getCode(), TranslateUtil.getTranslateName((String)BaseExceptionEnum.SERVER_EXCEPTION.getMessage()));
            }
            map.put("enabledEncryptSign", initEncryptInfo.isEnabledEncryptSign());
            map.put("headerEncrypt", initEncryptInfo.getHeaderEncrypt());
            map.put("hussarFP", initEncryptInfo.getFrontPriKey());
            map.put("hussarBP", initEncryptInfo.getBackendPubKey());
            map.put("enableEncryptCbcMode", initEncryptInfo.getEnableEncryptCbcMode());
        }
    }
}

