/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.calendar.controller;

import com.jxdinfo.hussar.general.calendar.feign.RemoteCalendarRefService;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Feign\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406"})
public class RemoteCalendarFrontController
implements RemoteCalendarRefService {
    @Resource
    private ISysCalendarRefService sysCalendarRefService;

    @ApiOperation(value="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4", notes="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public String getEndDateDefult(String startTime, String timeFrame, boolean isWorkCalendar) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTimeDate = LocalDateTime.parse(startTime, dateTimeFormatter);
        LocalDateTime result = this.sysCalendarRefService.getEndDateDefult(startTimeDate, timeFrame, isWorkCalendar);
        return result.format(dateTimeFormatter);
    }

    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u8303\u56f4\u83b7\u53d6\u5de5\u4f5c\u65e5\u5929\u6570", notes="\u6839\u636e\u65f6\u95f4\u8303\u56f4\u83b7\u53d6\u5de5\u4f5c\u65e5\u5929\u6570")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u6839\u636e\u65f6\u95f4\u8303\u56f4\u83b7\u53d6\u5de5\u4f5c\u65e5\u5929\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public Integer getWorkDays(String startTime, String endTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTimeDate = LocalDateTime.parse(startTime, dateTimeFormatter);
        LocalDateTime endTimeDate = LocalDateTime.parse(endTime, dateTimeFormatter);
        return this.sysCalendarRefService.getWorkDays(startTimeDate, endTimeDate);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u6708\u4efd\u7684\u5de5\u4f5c\u65e5\u5929\u6570", notes="\u83b7\u53d6\u6307\u5b9a\u6708\u4efd\u7684\u5de5\u4f5c\u65e5\u5929\u6570")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6307\u5b9a\u6708\u4efd\u7684\u5de5\u4f5c\u65e5\u5929\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public Integer getWorkDaysByMonth(String selectMonth) {
        return this.sysCalendarRefService.getWorkDaysByMonth(selectMonth);
    }

    @ApiOperation(value="\u5224\u65ad\u6307\u5b9a\u65e5\u671f\u662f\u5426\u662f\u5de5\u4f5c\u65e5", notes="\u5224\u65ad\u6307\u5b9a\u65e5\u671f\u662f\u5426\u662f\u5de5\u4f5c\u65e5")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u5224\u65ad\u6307\u5b9a\u65e5\u671f\u662f\u5426\u662f\u5de5\u4f5c\u65e5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public Boolean isWorkDay(String selectDay) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTimeDate = LocalDateTime.parse(selectDay, dateTimeFormatter);
        return this.sysCalendarRefService.isWorkDay(startTimeDate);
    }

    @ApiOperation(value="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4", notes="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public LocalDateTime getDueDateDefult(String startTime, String timeFrame, boolean isWorkCalendar) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTimeDate = LocalDateTime.parse(startTime, dateTimeFormatter);
        return this.sysCalendarRefService.getDueDateDefult(startTimeDate, timeFrame, isWorkCalendar);
    }

    @ApiOperation(value="\u6839\u636e\u7ed3\u675f\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u5f00\u59cb\u65f6\u95f4", notes="\u6839\u636e\u7ed3\u675f\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u5f00\u59cb\u65f6\u95f4")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u6839\u636e\u7ed3\u675f\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u5f00\u59cb\u65f6\u95f4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public LocalDateTime getBeginDateDefult(String endTime, String timeFrame, boolean isWorkCalendar) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime endTimeDate = LocalDateTime.parse(endTime, dateTimeFormatter);
        return this.sysCalendarRefService.getBeginDateDefult(endTimeDate, timeFrame, isWorkCalendar);
    }
}

