/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.general.enums.GeneralServicesTipsEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.general.dict.service.impl.SysDicSingleServiceImpl")
public class SysDicSingleServiceImpl
extends HussarServiceImpl<SysDicSingleMapper, DicSingle>
implements ISysDicSingleService {
    @Resource
    private SysDicTypeMapper dicTypeMapper;
    @Resource
    private SysDicSingleMapper sysDicSingleMapper;
    @Resource
    private ISysDicSingleService sysDicSingleService;

    public void evictTypeCacheBySingleId(Long id) {
        DicSingle dic = (DicSingle)this.getById(id);
        DicType type = (DicType)this.dicTypeMapper.selectById(dic.getTypeId());
        if (ToolUtil.isNotEmpty((Object)type)) {
            HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)("dict_of_type:" + type.getTypeName()));
        }
    }

    public List<DicVo> getDicListByType(Long typeId) {
        return this.sysDicSingleMapper.getDicListByType(typeId);
    }

    public List<DicVo> getCertainDictOptions(Long typeId, String[] optionValues) {
        return this.sysDicSingleMapper.getCertainDictOptions(typeId, optionValues);
    }

    public List<DicVo> getDictOptionsWithoutNotShows(Long typeId, String[] notShows) {
        return this.sysDicSingleMapper.getDictOptionsWithoutNotShows(typeId, notShows);
    }

    public String getDictLabel(Long typeId, String value) {
        DicSingle t = new DicSingle();
        t.setTypeId(typeId);
        t.setValue(value);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)t);
        DicSingle dic = (DicSingle)this.sysDicSingleMapper.selectOne((Wrapper)wrapper);
        if (ToolUtil.isNotEmpty((Object)dic)) {
            return dic.getLabel();
        }
        return "";
    }

    public String getDictValue(Long typeId, String label) {
        DicSingle t = new DicSingle();
        t.setTypeId(typeId);
        t.setLabel(label);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)t);
        DicSingle dic = (DicSingle)this.sysDicSingleMapper.selectOne((Wrapper)wrapper);
        if (ToolUtil.isNotEmpty((Object)dic)) {
            return dic.getValue();
        }
        return "";
    }

    public ApiResponse deleteSingle(List<String> ids) {
        if (ToolUtil.isEmpty(ids)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DELETE_PARAM_EMPTY.getMessage()));
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        List idL = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        if (!this.removeByIds(idL)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_DELETE_FAIL.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.GENERAL_DELETE_SUCCESS.getMessage()));
    }

    public ApiResponse<DicSingle> selectById(String dictId) {
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.QUERY_PARAM_EMPTY.getMessage()));
        }
        return ApiResponse.success((Object)this.getById((Serializable)((Object)dictId)));
    }

    public String changeToPinyin(String chineseName, HanyuPinyinCaseType caseType) {
        char[] clChars = chineseName.trim().toCharArray();
        String hanyupinyin = "";
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(caseType);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            for (int i = 0; i < clChars.length; ++i) {
                hanyupinyin = String.valueOf(clChars[i]).matches("[\u4e00-\u9fa5]+") ? hanyupinyin + PinyinHelper.toHanyuPinyinStringArray((char)clChars[i], (HanyuPinyinOutputFormat)defaultFormat)[0] : hanyupinyin + clChars[i];
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return hanyupinyin;
    }

    public List<DicSingle> getDicSingleByTypeAndField(List<DicSingle> dicSingles, String fieldName) {
        ArrayList<DicSingle> returnList = new ArrayList<DicSingle>();
        LambdaQueryWrapper dicSingleLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < dicSingles.size(); i += 699) {
            List<DicSingle> temp;
            if (i + 699 >= dicSingles.size()) {
                temp = dicSingles.subList(i, dicSingles.size());
                dicSingleLambdaQueryWrapper.clear();
                for (DicSingle dicSingle : temp) {
                    ((LambdaQueryWrapper)dicSingleLambdaQueryWrapper.or()).eq(DicSingle::getTypeId, (Object)dicSingle.getTypeId());
                    if (HussarUtils.equals((Object)"value", (Object)fieldName)) {
                        dicSingleLambdaQueryWrapper.eq(DicSingle::getValue, (Object)dicSingle.getValue());
                    }
                    if (!HussarUtils.equals((Object)"label", (Object)fieldName)) continue;
                    dicSingleLambdaQueryWrapper.eq(DicSingle::getLabel, (Object)dicSingle.getLabel());
                }
                returnList.addAll(this.sysDicSingleMapper.selectList((Wrapper)dicSingleLambdaQueryWrapper));
                continue;
            }
            temp = dicSingles.subList(i, i + 699);
            dicSingleLambdaQueryWrapper.clear();
            for (DicSingle dicSingle : temp) {
                ((LambdaQueryWrapper)dicSingleLambdaQueryWrapper.or()).eq(DicSingle::getTypeId, (Object)dicSingle.getTypeId());
                if (HussarUtils.equals((Object)"value", (Object)fieldName)) {
                    dicSingleLambdaQueryWrapper.eq(DicSingle::getValue, (Object)dicSingle.getValue());
                }
                if (!HussarUtils.equals((Object)"label", (Object)fieldName)) continue;
                dicSingleLambdaQueryWrapper.eq(DicSingle::getLabel, (Object)dicSingle.getLabel());
            }
            returnList.addAll(this.sysDicSingleMapper.selectList((Wrapper)dicSingleLambdaQueryWrapper));
        }
        return returnList;
    }

    public boolean insertOrUpdateList(List<DicSingle> dicSingles) {
        if (CollectionUtils.isEmpty(dicSingles)) {
            return false;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = dicSingles.size();
            for (int i = 0; i < size; ++i) {
                DicSingle dicSingle = dicSingles.get(i);
                DicSingle single = (DicSingle)this.sysDicSingleMapper.selectById(dicSingle.getId());
                if (HussarUtils.isNotEmpty((Object)single)) {
                    this.sysDicSingleMapper.updateDicSingle(dicSingle);
                } else {
                    this.sysDicSingleService.save((Object)dicSingle);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_INSERT_OR_UPDATE_ERROR.getMessage()), e);
        }
        return true;
    }

    public List<DicSingle> getDicSingleByTypeIds(List<Long> typeIds, int parentIdType) {
        LambdaQueryWrapper dicSingleLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty(typeIds)) {
            return Collections.emptyList();
        }
        LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)dicSingleLambdaQueryWrapper, DicSingle::getTypeId, typeIds);
        if (parentIdType == 0) {
            dicSingleLambdaQueryWrapper.isNull(DicSingle::getParentId);
        } else if (parentIdType == 1) {
            dicSingleLambdaQueryWrapper.isNotNull(DicSingle::getParentId);
        }
        dicSingleLambdaQueryWrapper.orderByAsc(DicSingle::getSort);
        return this.sysDicSingleService.list((Wrapper)dicSingleLambdaQueryWrapper);
    }

    public List<DicSingle> getDicSinglesByTypeIdsOrderByTypeSort(List<Long> typeIds) {
        return this.sysDicSingleMapper.getDicSinglesByTypeIdsOrderByTypeSort(typeIds);
    }

    public List<DicSingle> getAllDictSingleInDB() {
        return this.sysDicSingleMapper.getAllDictSingleInDB();
    }

    public boolean updateSingleForUpdateToNoParent(List<Long> singleIds) {
        return this.sysDicSingleMapper.updateSingleForUpdateToNoParent(singleIds);
    }
}

