/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.calendar.service.feign.impl;

import com.jxdinfo.hussar.general.calendar.feign.RemoteCalendarRefService;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RemoteCalendarRefServiceImpl
implements ISysCalendarRefService {
    @Resource
    private RemoteCalendarRefService remoteCalendarRefService;

    public LocalDateTime getEndDateDefult(LocalDateTime startTime, String timeFrame, boolean isWorkCalendar) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String startTimeString = startTime.format(dateTimeFormatter);
        String result = this.remoteCalendarRefService.getEndDateDefult(startTimeString, timeFrame, isWorkCalendar);
        return LocalDateTime.parse(result, dateTimeFormatter);
    }

    public Integer getWorkDays(LocalDateTime startTime, LocalDateTime endTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String startTimeString = startTime.format(dateTimeFormatter);
        return this.remoteCalendarRefService.getWorkDays(startTimeString, startTimeString);
    }

    public Integer getWorkDaysByMonth(String selectMonth) {
        return this.remoteCalendarRefService.getWorkDaysByMonth(selectMonth);
    }

    public Boolean isWorkDay(LocalDateTime selectDay) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String selectDayString = selectDay.format(dateTimeFormatter);
        return this.remoteCalendarRefService.isWorkDay(selectDayString);
    }

    public LocalDateTime getDueDateDefult(LocalDateTime startTime, String timeFrame, boolean isWorkCalendar) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String startTimeString = startTime.format(dateTimeFormatter);
        return this.remoteCalendarRefService.getDueDateDefult(startTimeString, timeFrame, isWorkCalendar);
    }
}

