/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.common.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="hussar.data-scope")
public class HussarBaseDataScopeProperties {
    public static final String PREFIX = "hussar.data-scope";
    private Boolean enable = true;
    private Set<String> mapperKey;
    private Set<String> mapperExclude;
    private static final Set<String> defaultMapperKey = new HashSet<String>();
    private static final Set<String> defaultMapperExclude = new HashSet<String>();

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Set<String> getMapperKey() {
        HashSet<String> mapperKeyAll = new HashSet<String>();
        if (HussarUtils.isNotEmpty(this.mapperKey)) {
            mapperKeyAll.addAll(this.mapperKey);
        }
        mapperKeyAll.addAll(defaultMapperKey);
        return mapperKeyAll;
    }

    public void setMapperKey(Set<String> mapperKey) {
        this.mapperKey = mapperKey;
    }

    public Set<String> getMapperExclude() {
        HashSet<String> mapperExcludeAll = new HashSet<String>();
        if (HussarUtils.isNotEmpty(this.mapperExclude)) {
            mapperExcludeAll.addAll(this.mapperExclude);
        }
        mapperExcludeAll.addAll(defaultMapperExclude);
        return mapperExcludeAll;
    }

    public void setMapperExclude(Set<String> mapperExclude) {
        this.mapperExclude = mapperExclude;
    }

    static {
        defaultMapperExclude.add("DmlMapper");
        defaultMapperKey.add("page");
        defaultMapperKey.add("list");
        defaultMapperKey.add("query");
        defaultMapperKey.add("search");
    }
}

