/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.timejob;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.datasource.dao.SysDataSourceMapper;
import com.jxdinfo.hussar.bsp.datasource.model.SysDataSource;
import com.jxdinfo.hussar.bsp.permit.AccountStatusChangeMailUtil;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.quartz.job.BaseJob;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.stereotype.Component;

@DisallowConcurrentExecution
@Component
public class AccountJob
implements BaseJob {
    private static Logger log = LogManager.getLogger(AccountJob.class);
    private GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
    private static CountDownLatch latch;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info("Account Job\u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        if (this.globalProperties.isTenantOpen()) {
            this.createThread();
        } else {
            this.quartzJob();
        }
        log.info("Account Job\u7ed3\u675f\u6267\u884c\u65f6\u95f4:" + Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
    }

    private void quartzJob() {
        List<SysUsers> logoutWarnList;
        ISysBaseConfigService iSysBaseConfigService;
        String status;
        ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
        List<SysUsers> notLoginList = iSysUsersService.updateUserStatusToLock(status = (iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class)).getSysBaseConfig("user_account_status").getConfigValue());
        if (ToolUtil.isNotEmpty(notLoginList)) {
            for (SysUsers sysUsers : notLoginList) {
                if (sysUsers.getEMail() == null || "".equals(sysUsers.getEMail())) continue;
                AccountStatusChangeMailUtil.sendMail(sysUsers, status);
            }
        }
        if (ToolUtil.isNotEmpty(logoutWarnList = iSysUsersService.getWillLogoutList())) {
            for (SysUsers sysUsers : logoutWarnList) {
                if (sysUsers.getEMail() == null || "".equals(sysUsers.getEMail())) continue;
                AccountStatusChangeMailUtil.sendMail(sysUsers, UserStatus.CANCEL.getCode());
            }
        }
        iSysUsersService.updateUserStatusToCancel();
    }

    private void createThread() {
        SysDataSourceMapper sysDataSourceMapper = (SysDataSourceMapper)SpringContextHolder.getBean(SysDataSourceMapper.class);
        List<SysDataSource> sysDataSourceList = sysDataSourceMapper.getAllTenantDataSource();
        latch = new CountDownLatch(sysDataSourceList.size() + 1);
        QuartzThread quartzThread = new QuartzThread(null);
        quartzThread.start();
        if (ToolUtil.isNotEmpty(sysDataSourceList)) {
            DruidProperties druidProperties = (DruidProperties)SpringContextHolder.getBean(DruidProperties.class);
            for (SysDataSource sysDataSource : sysDataSourceList) {
                boolean flag = true;
                try {
                    if (ToolUtil.isEmpty((Object)DataSourceUtil.getDataSource((String)sysDataSource.getConnName()))) {
                        flag = false;
                    }
                }
                catch (RuntimeException ex) {
                    flag = false;
                }
                if (!flag) {
                    DataSourceProperty property = new DataSourceProperty();
                    property.setDruid(druidProperties.getDruid());
                    property.setPoolName(sysDataSource.getConnName());
                    property.setDriverClassName(sysDataSource.getDriverClass());
                    property.setUrl(sysDataSource.getJdbcUrl());
                    property.setUsername(sysDataSource.getUserName());
                    property.setPassword(sysDataSource.getPassword());
                    DataSourceUtil.addDataSource((DataSourceProperty)property);
                }
                QuartzThread tenantThread = new QuartzThread(sysDataSource.getConnName());
                tenantThread.start();
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage());
            Thread.currentThread().interrupt();
        }
    }

    private class QuartzThread
    extends Thread {
        private String dbName;

        @Override
        public void run() {
            try {
                if (this.dbName != null) {
                    DataSourceUtil.changeTempDs((String)this.dbName);
                }
                AccountJob.this.quartzJob();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                latch.countDown();
                DataSourceUtil.poll();
            }
        }

        QuartzThread(String dbName) {
            this.dbName = dbName;
        }
    }
}

