/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.isc.session;

import com.jxdinfo.hussar.isc.session.SingleSignOutFilter;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListener;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="ISC", matchIfMissing=false)
public abstract class AbstractSingleSignOutHttpSessionListener
implements SessionListener {
    private SessionMappingStorage sessionMappingStorage;

    protected static SessionMappingStorage getSessionMappingStorage() {
        return SingleSignOutFilter.getSingleSignOutHandler().getSessionMappingStorage();
    }

    public void onStop(Session session) {
        if (this.sessionMappingStorage == null) {
            this.sessionMappingStorage = AbstractSingleSignOutHttpSessionListener.getSessionMappingStorage();
        }
        this.sessionMappingStorage.removeBySessionById(session.getId().toString());
    }

    public void onExpiration(Session session) {
        if (this.sessionMappingStorage == null) {
            this.sessionMappingStorage = AbstractSingleSignOutHttpSessionListener.getSessionMappingStorage();
        }
        this.sessionMappingStorage.removeBySessionById(session.getId().toString());
    }
}

