/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.isc.listener;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.isc.conf.ShiroIscConfiguration;
import com.jxdinfo.hussar.isc.session.AbstractSingleSignOutHttpSessionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import org.apache.shiro.session.Session;
import org.pac4j.core.profile.CommonProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
@ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="ISC", matchIfMissing=false)
public class IscSingleSignOutHttpSessionListener
extends AbstractSingleSignOutHttpSessionListener {
    @Autowired
    ShiroIscConfiguration shiroIscConfiguration;
    private String appId;
    private String clientName;
    private String ssoServerUrl;
    private int sessionTimeout = -1;

    public void onStart(Session session) {
        Boolean active = this.shiroIscConfiguration.isActive();
        if (active != null && Boolean.valueOf(active).booleanValue()) {
            if (this.appId == null) {
                this.appId = this.shiroIscConfiguration.getAppId();
            }
            if (this.ssoServerUrl == null) {
                this.ssoServerUrl = this.shiroIscConfiguration.getServerUrlPrefix();
            }
            if (this.clientName == null) {
                this.clientName = this.shiroIscConfiguration.getClientName();
            }
            this.checkUrlLoaded(session);
            int timeout = this.getTimeout();
            if (timeout > -1) {
                session.setTimeout((long)this.getTimeout());
            }
        }
    }

    @Override
    public void onExpiration(Session session) {
        String destoryType = (String)session.getAttribute((Object)"destoryType");
        if (destoryType != null && !"casServer".equals(destoryType)) {
            super.onExpiration(session);
            try {
                this.checkUrlLoaded(session);
                LinkedHashMap linkMap = (LinkedHashMap)session.getAttribute((Object)"pac4jUserProfiles");
                CommonProfile profile = (CommonProfile)linkMap.get(this.clientName);
                String id = profile.getId();
                JSONObject json = JSONObject.parseObject((String)URLDecoder.decode(id, "UTF-8"));
                String iscUserId = json.get((Object)"iscUserId").toString();
                this.destoryUser(iscUserId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onStop(Session session) {
        this.onExpiration(session);
    }

    private void checkUrlLoaded(Session session) {
        Boolean active = this.shiroIscConfiguration.isActive();
        if (active != null && Boolean.valueOf(active).booleanValue()) {
            if (this.appId == null) {
                this.appId = this.shiroIscConfiguration.getAppId();
            }
            if (this.ssoServerUrl == null) {
                this.ssoServerUrl = this.shiroIscConfiguration.getServerLoginUrl();
            }
            if (this.clientName == null) {
                this.clientName = this.shiroIscConfiguration.getClientName();
            }
        }
    }

    private int getTimeout() {
        try {
            if (this.appId != null) {
                String json = this.postRequest(this.ssoServerUrl + "/loadSessionPolicy?appid=" + this.appId);
                JSONObject policy = JSONObject.parseObject((String)json);
                this.sessionTimeout = policy.getIntValue("sessionTimeout") * 1000;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return this.sessionTimeout;
    }

    private void destoryUser(String userId) throws Exception {
        String addr = this.ssoServerUrl + "/timeout?userId=" + userId;
        this.postRequest(addr);
    }

    public void sendSafetyWarning(Session session, String loginName, String ip) throws Exception {
        this.checkUrlLoaded(session);
        String addr = this.ssoServerUrl + "/sendSafetyWarning?loginName=" + loginName + "&IP=" + ip;
        this.postRequest(addr);
    }

    private String postRequest(String url) throws Exception {
        HttpURLConnection httpConnection = null;
        URL addr = new URL(url);
        httpConnection = (HttpURLConnection)addr.openConnection();
        httpConnection.setRequestMethod("POST");
        httpConnection.setConnectTimeout(90000);
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        httpConnection.setUseCaches(false);
        HttpURLConnection.setFollowRedirects(true);
        httpConnection.setRequestProperty("Content-Type", "application/x-www.form-urlencoded");
        httpConnection.connect();
        int statusCode = httpConnection.getResponseCode();
        InputStream httpIn = httpConnection.getInputStream();
        String respText = this.readResponseBody(httpIn);
        httpIn.close();
        if (statusCode != 200) {
            httpConnection.disconnect();
            throw new Exception("\u8bf7\u6c42\u6ce8\u9500\u7528\u6237ticket\u9519\u8bef,code:" + statusCode + ",messgae:" + respText);
        }
        httpConnection.disconnect();
        return respText;
    }

    private String readResponseBody(InputStream istream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[63];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        byte[] ret = bout.toByteArray();
        return new String(ret);
    }
}

