/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.util;

import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.mail.util.HussarMailUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class UnauthorizedMailUtil {
    private static GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);

    public static void sendMail(UnauthorizedException e, HttpServletRequest request) {
        List<String> tos = Arrays.asList(globalProperties.getExceptionAlertEmail().split(","));
        ShiroUser shiroUser = ShiroKit.getUser();
        StringBuilder content = new StringBuilder();
        if (shiroUser != null) {
            content.append("\u7528\u6237\u8d26\u53f7:").append(shiroUser.getAccount()).append(";").append("</br>");
            content.append("\u7528\u6237\u59d3\u540d:").append(shiroUser.getName()).append(";").append("</br>");
            content.append("\u6240\u5c5e\u90e8\u95e8:").append(shiroUser.getDeptName()).append(";").append("</br>");
        }
        content.append("sessionId:").append((String)((Object)ShiroKit.getSession().getId())).append(";").append("</br>");
        content.append("\u8bbf\u95eeIP:").append(HttpKit.getIp()).append(";").append("</br>");
        content.append("\u5e94\u7528\u7cfb\u7edfIP:").append(HttpKit.getLocalIp()).append(";").append("</br>");
        content.append("\u8bbf\u95ee\u65b9\u6cd5:").append(request.getRequestURI()).append(";").append("</br>");
        content.append("\u8be6\u7ec6\u4fe1\u606f:").append(e.getCause().getMessage());
        HussarMailUtils.send(tos, (String)"\u5b58\u5728\u8d8a\u6743\u8bbf\u95ee\u5f02\u5e38", (String)content.toString(), (boolean)true, (File[])new File[0]);
    }
}

