/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.util;

import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class DataExportUtils {
    private static Logger logger = LoggerFactory.getLogger(DataExportUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byteToFile(byte[] contents, String fileName, HttpServletResponse response) {
        String newFileName = fileName;
        HussarProperties hussarProperties = (HussarProperties)((Object)SpringContextHolder.getBean(HussarProperties.class));
        String filePath = hussarProperties.getFileUploadPath() + File.separator + newFileName;
        File file = new File(filePath);
        File path = file.getParentFile();
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(contents));
             FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream output = new BufferedOutputStream(fos);){
            if (!path.exists()) {
                logger.info("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u3002path={}", (Object)path);
                boolean isCreated = path.mkdirs();
                if (!isCreated) {
                    logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff0cpath={}", (Object)path);
                }
            }
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                output.write(buffer, 0, length);
                length = bis.read(buffer);
            }
            output.flush();
            newFileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("multipart/form-data");
            try (BufferedInputStream bism = new BufferedInputStream(new FileInputStream(file), 10240);
                 BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int len = 0;
                int i = bism.available();
                byte[] buff = new byte[i];
                while ((len = bism.read(buff)) > 0) {
                    bos.write(buff, 0, len);
                    bos.flush();
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}", (Object)filePath, (Object)e);
        }
        finally {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException ex) {
                logger.error("\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff0cfilePath={}", (Object)filePath, (Object)ex);
            }
        }
    }
}

