/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.sys.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.core.sys.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.vo.DicVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysDicSingleServiceImpl
extends ServiceImpl<SysDicSingleMapper, DicSingle>
implements ISysDicSingleService {
    @Resource
    private SysDicTypeMapper dicTypeMapper;
    @Resource
    private HussarCacheManager hussarCacheManager;
    @Resource
    private SysDicSingleMapper sysDicSingleMapper;

    @Override
    public void evictTypeCacheBySingleId(String id) {
        DicSingle dic = (DicSingle)((Object)this.getById((Serializable)((Object)id)));
        DicType type = (DicType)((Object)this.dicTypeMapper.selectById((Serializable)((Object)dic.getTypeId())));
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:" + type.getTypeName());
        }
    }

    @Override
    public List<DicVo> getDicListByType(String typeId) {
        return this.sysDicSingleMapper.getDicListByType(typeId);
    }

    @Override
    public List<DicVo> getCertainDictOptions(String typeId, String[] optionValues) {
        return this.sysDicSingleMapper.getCertainDictOptions(typeId, optionValues);
    }

    @Override
    public List<DicVo> getDictOptionsWithoutNotShows(String typeId, String[] notShows) {
        return this.sysDicSingleMapper.getDictOptionsWithoutNotShows(typeId, notShows);
    }

    @Override
    public String getDictLabel(String typeId, String value) {
        DicSingle t = new DicSingle();
        t.setTypeId(typeId);
        t.setValue(value);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)t);
        DicSingle dic = (DicSingle)((Object)this.sysDicSingleMapper.selectOne((Wrapper)wrapper));
        if (ToolUtil.isNotEmpty((Object)((Object)dic))) {
            return dic.getLabel();
        }
        return "";
    }

    @Override
    public String getDictValue(String typeId, String label) {
        DicSingle t = new DicSingle();
        t.setTypeId(typeId);
        t.setLabel(label);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)t);
        DicSingle dic = (DicSingle)((Object)this.sysDicSingleMapper.selectOne((Wrapper)wrapper));
        if (ToolUtil.isNotEmpty((Object)((Object)dic))) {
            return dic.getValue();
        }
        return "";
    }
}

