/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.sys.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.service.ISysDicTypeService;
import com.jxdinfo.hussar.core.sys.vo.DicVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDicRefServiceImpl
implements ISysDicRefService {
    @Autowired
    private ISysDicSingleService dicSingleService;
    @Autowired
    private ISysDicTypeService dicTypeService;
    @Resource
    private HussarCacheManager hussarCacheManager;

    @Override
    public List<DicSingle> getDictByType(String typeName) {
        DicType type;
        List<DicSingle> result = new ArrayList<DicSingle>();
        String key = "dict_of_type:" + DataSourceUtil.currentDsName() + ":" + typeName + ":list";
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)((Object)(type = this.getTypeInfo(typeName))))) {
            Wrapper wp = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"type_id", (Object)type.getId())).orderByAsc((Object)"SORT");
            result = this.dicSingleService.list(wp);
        }
        return result;
    }

    @Override
    public LinkedHashMap<String, Object> getDictMapByType(String typeName) {
        String key = "dict_of_type:" + DataSourceUtil.currentDsName() + ":" + typeName + ":map";
        LinkedHashMap<String, String> result = (LinkedHashMap<String, String>)this.hussarCacheManager.getObject("hussar_dict_of_type_cache", key);
        if (ToolUtil.isEmpty((Object)result)) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            List<DicSingle> list = this.getDictByType(typeName);
            for (DicSingle dicSingle : list) {
                linkedHashMap.put(dicSingle.getValue(), dicSingle.getLabel());
            }
            result = linkedHashMap;
            this.hussarCacheManager.setObject("hussar_dict_of_type_cache", key, linkedHashMap);
        }
        return result;
    }

    @Override
    public List<DicVo> getDicListByType(String typeName) {
        DicType type;
        List<Object> result = new ArrayList();
        String key = "dict_of_type:" + DataSourceUtil.currentDsName() + ":" + typeName + ":allShow";
        result = (List)this.hussarCacheManager.getObject("hussar_dict_of_type_cache", key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)((Object)(type = this.getTypeInfo(typeName))))) {
            result = this.dicSingleService.getDicListByType(type.getId());
            this.hussarCacheManager.setObject("hussar_dict_of_type_cache", key, result);
        }
        return result;
    }

    @Override
    public List<DicVo> getCertainDictOptions(String typeName, String[] optionValues) {
        DicType type;
        List<Object> result = new ArrayList();
        String key = "dict_of_type:" + DataSourceUtil.currentDsName() + ":" + typeName + ":onlyShow";
        result = (List)this.hussarCacheManager.getObject("hussar_dict_of_type_cache", key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)((Object)(type = this.getTypeInfo(typeName))))) {
            result = this.dicSingleService.getCertainDictOptions(type.getId(), optionValues);
            this.hussarCacheManager.setObject("hussar_dict_of_type_cache", key, result);
        }
        return result;
    }

    @Override
    public List<DicVo> getDictOptionsWithoutNotShows(String typeName, String[] notShows) {
        DicType type;
        List<Object> result = new ArrayList();
        String key = "dict_of_type:" + DataSourceUtil.currentDsName() + ":" + typeName + ":notShow";
        result = (List)this.hussarCacheManager.getObject("hussar_dict_of_type_cache", key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)((Object)(type = this.getTypeInfo(typeName))))) {
            result = this.dicSingleService.getDictOptionsWithoutNotShows(type.getId(), notShows);
            this.hussarCacheManager.setObject("hussar_dict_of_type_cache", key, result);
        }
        return result;
    }

    @Override
    public String getDictLabel(String typeName, String value) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (!ToolUtil.isOneEmpty((Object[])new Object[]{type, value})) {
            result = this.dicSingleService.getDictLabel(type.getId(), value);
        }
        return result;
    }

    @Override
    public String getDictValue(String typeName, String label) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getDictValue(type.getId(), label);
        }
        return result;
    }

    @Override
    public String getDictOptionsInJson(String typeName) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        List<DicSingle> list = this.getDictByType(typeName);
        for (DicSingle dicSingle : list) {
            linkedHashMap.put(dicSingle.getLabel(), dicSingle.getValue());
        }
        return JSON.toJSONString(linkedHashMap);
    }

    private DicType getTypeInfo(String typeName) {
        return (DicType)((Object)this.dicTypeService.getOne((Wrapper)new QueryWrapper().eq((Object)"type_name", (Object)typeName), false));
    }
}

