/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.sys.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.SysCalendar;
import com.jxdinfo.hussar.core.sys.service.ISysCalendarService;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/calendar"})
public class WorkCalendarController
extends BaseController {
    @Resource
    private ISysCalendarService sysCalendarService;
    @Resource
    private ISysDicRefService sysDicRefService;
    private static String PREFIX = "/core/sys/calendar/";

    @RequestMapping(value={"/view"})
    @BussinessLog(key="/calendar/view", type="04", value="\u5de5\u4f5c\u65e5\u5386\u9875\u9762")
    @RequiresPermissions(value={"calendar:view"})
    public String index() {
        return PREFIX + "calendar_index.html";
    }

    @RequestMapping(value={"/addOneView/{theDate}"})
    @BussinessLog(key="/calendar/addOneView/{theDate}", type="04", value="\u65b0\u589e\u5355\u65e5\u4e8b\u4ef6\u9875\u9762")
    public String eventAddOne(@PathVariable String theDate, Model model) {
        model.addAttribute("theDate", (Object)theDate);
        return PREFIX + "event_add_one.html";
    }

    @RequiresPermissions(value={"calendar:addView"})
    @RequestMapping(value={"/addView"})
    @BussinessLog(key="/calendar/addView", type="04", value="\u6279\u91cf\u65b0\u589e\u4e8b\u4ef6\u9875\u9762")
    public String eventAdd() {
        return PREFIX + "event_add_multi.html";
    }

    @RequestMapping(value={"/editView/{eventId}"})
    @BussinessLog(key="/calendar/editView/{eventId}", type="04", value="\u4fee\u6539\u9875\u9762")
    public String eventEdit(@PathVariable String eventId, Model model) {
        SysCalendar event = (SysCalendar)((Object)this.sysCalendarService.getById((Serializable)((Object)eventId)));
        model.addAttribute("event", (Object)event);
        return PREFIX + "event_edit.html";
    }

    @RequiresPermissions(value={"calendar:deleteView"})
    @RequestMapping(value={"/deleteView"})
    @BussinessLog(key="/calendar/deleteView", type="04", value="\u6279\u91cf\u5220\u9664\u4e8b\u4ef6\u9875\u9762")
    public String eventDelete() {
        return PREFIX + "event_delete_multi.html";
    }

    @RequiresPermissions(value={"calendar:calendarEventTypeOption"})
    @RequestMapping(value={"/calendarEventTypeOption"})
    @BussinessLog(key="/calendar/calendarEventTypeOption", type="04", value="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6\u7c7b\u578b\u4e0b\u62c9\u6846")
    @ResponseBody
    public List<DicSingle> calendarEventTypeOption() {
        List<DicSingle> list = this.sysDicRefService.getDictByType("calendar_event_type");
        return list;
    }

    @RequiresPermissions(value={"calendar:list"})
    @RequestMapping(value={"/list"})
    @BussinessLog(key="/calendar/list", type="04", value="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6")
    @ResponseBody
    public List<SysCalendar> eventsList() {
        String startTime = super.getPara("startTime").trim();
        String endTime = super.getPara("endTime").trim();
        Date start = ToolUtil.isEmpty((Object)startTime) ? null : DateUtil.parse((String)startTime, (String)"yyyy-MM-dd");
        Date end = ToolUtil.isEmpty((Object)startTime) ? null : DateUtil.parse((String)endTime, (String)"yyyy-MM-dd");
        return this.sysCalendarService.getEventsBetweenDate(start, end);
    }

    @RequestMapping(value={"/addEvent"})
    @ResponseBody
    @BussinessLog(key="/calendar/addEvent", type="01", value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u65b0\u589e")
    @RequiresPermissions(value={"calendar:addEvent"})
    public Tip addEvent(SysCalendar sysCalendar) {
        List<SysCalendar> calendarList = this.sysCalendarService.getEventsBetweenDate(sysCalendar.getStartTime(), sysCalendar.getEndTime());
        if (ToolUtil.isNotEmpty(calendarList)) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u8be5\u65f6\u95f4\u8303\u56f4\u5185\u5df2\u5b58\u5728\u4e8b\u4ef6\uff01\uff09");
        }
        List<Date> list = this.getBetweenDates(sysCalendar.getStartTime(), sysCalendar.getEndTime());
        if (list.size() > 31) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u65b0\u589e\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e2a\u6708\uff09");
        }
        Date createTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String creator = ShiroKit.getUser().getAccount();
        ArrayList<SysCalendar> sysCalendarList = new ArrayList<SysCalendar>();
        for (Date start : list) {
            SysCalendar cal = new SysCalendar();
            cal.setTitle(sysCalendar.getTitle());
            cal.setClassName(sysCalendar.getClassName());
            cal.setRemark(sysCalendar.getRemark());
            cal.setCreator(creator);
            cal.setCreateTime(createTime);
            cal.setStartTime(start);
            sysCalendarList.add(cal);
        }
        if (ToolUtil.isNotEmpty(sysCalendarList)) {
            this.sysCalendarService.saveBatch(sysCalendarList, sysCalendarList.size());
        }
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/addOneEvent"})
    @ResponseBody
    @BussinessLog(key="/calendar/addOneEvent", type="01", value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u65b0\u589e")
    @RequiresPermissions(value={"calendar:addOneEvent"})
    public Tip addOneEvent(SysCalendar sysCalendar) {
        Date createTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String creator = ShiroKit.getUser().getAccount();
        sysCalendar.setCreator(creator);
        sysCalendar.setCreateTime(createTime);
        this.sysCalendarService.save((Object)sysCalendar);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/editEvent"})
    @ResponseBody
    @BussinessLog(key="/calendar/editEvent", type="03", value="\u5de5\u4f5c\u65e5\u5386\u4fee\u6539")
    @RequiresPermissions(value={"calendar:editEvent"})
    public Tip editEvent(SysCalendar sysCalendar) {
        this.sysCalendarService.updateById((Object)sysCalendar);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/delEvent"})
    @ResponseBody
    @BussinessLog(key="/calendar/delEvent", type="02", value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u5220\u9664")
    @RequiresPermissions(value={"calendar:delEvent"})
    public Tip delEvent(SysCalendar sysCalendar) {
        this.sysCalendarService.remove((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ge((Object)"START_TIME", (Object)sysCalendar.getStartTime())).le((Object)"START_TIME", (Object)sysCalendar.getEndTime())).in((Object)"CLASS_NAME", new Object[]{sysCalendar.getClassName()}));
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/delOneEvent"})
    @ResponseBody
    @BussinessLog(key="/calendar/delOneEvent", type="02", value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u5220\u9664")
    @RequiresPermissions(value={"calendar:delOneEvent"})
    public Tip delOneEvent(String id) {
        this.sysCalendarService.removeById((Serializable)((Object)id));
        return SUCCESS_TIP;
    }

    private List<Date> getBetweenDates(Date startDate, Date endDate) {
        Date newStartDate = startDate;
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(newStartDate);
        while (newStartDate.getTime() <= endDate.getTime()) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
            newStartDate = tempStart.getTime();
        }
        return result;
    }
}

