/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.sessionlimit;

import com.jxdinfo.hussar.core.redis.service.RedisService;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.shiro.session.Session;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class RedisSessionLimit
implements SessionLimit {
    RedisService redisService = (RedisService)SpringContextHolder.getBean(RedisService.class);

    @Override
    public Deque<Serializable> getUserSession(String userId) {
        LinkedList deque = (LinkedList)this.redisService.getObject("same_user_sessions:" + userId);
        if (deque == null) {
            deque = new LinkedList();
        }
        return deque;
    }

    @Override
    public Deque<Serializable> getUserSession(String userId, String connName) {
        LinkedList deque = (LinkedList)this.redisService.getObject("same_user_sessions:" + userId + connName);
        if (deque == null) {
            deque = new LinkedList();
        }
        return deque;
    }

    @Override
    public void addUserSession(String userId, Deque<Serializable> deque) {
        this.redisService.setObject("same_user_sessions:" + userId, deque);
    }

    @Override
    public void addUserSession(String userId, String connName, Deque<Serializable> deque) {
        this.redisService.setObject("same_user_sessions:" + userId + connName, deque);
    }

    @Override
    public void removeBySession(Session session) {
        Deque deque;
        ShiroUser shiroUser = (ShiroUser)session.getAttribute((Object)"shiroUser");
        if (ToolUtil.isNotEmpty((Object)shiroUser) && ToolUtil.isNotEmpty((Object)(deque = (Deque)this.redisService.getObject("same_user_sessions:" + shiroUser.getId())))) {
            deque.remove(session.getId());
            this.redisService.setObject("same_user_sessions:" + shiroUser.getId(), (Object)deque);
        }
    }

    @Override
    public void removeBySession(Session session, String connName) {
        ShiroUser shiroUser = (ShiroUser)session.getAttribute((Object)"shiroUser");
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            String key = shiroUser.getId() + connName;
            Deque deque = (Deque)this.redisService.getObject("same_user_sessions:" + key);
            if (ToolUtil.isNotEmpty((Object)deque)) {
                deque.remove(session.getId());
                this.redisService.setObject("same_user_sessions:" + key, (Object)deque);
            }
        }
    }
}

