/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.sessionlimit;

import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shiro.session.Session;

public class MapSessionLimit
implements SessionLimit {
    private static Map<String, Deque<Serializable>> USERSESSION = new HashMap<String, Deque<Serializable>>();

    @Override
    public Deque<Serializable> getUserSession(String userId) {
        Deque<Serializable> deque = USERSESSION.get(userId);
        if (deque == null) {
            deque = new LinkedList<Serializable>();
        }
        return deque;
    }

    @Override
    public Deque<Serializable> getUserSession(String userId, String connName) {
        Deque<Serializable> deque = USERSESSION.get(userId + connName);
        if (deque == null) {
            deque = new LinkedList<Serializable>();
        }
        return deque;
    }

    @Override
    public void addUserSession(String userId, Deque<Serializable> deque) {
        USERSESSION.put(userId, deque);
    }

    @Override
    public void addUserSession(String userId, String connName, Deque<Serializable> deque) {
        USERSESSION.put(userId + connName, deque);
    }

    @Override
    public void removeBySession(Session session) {
        Deque<Serializable> deque;
        ShiroUser shiroUser = (ShiroUser)session.getAttribute((Object)"shiroUser");
        if (ToolUtil.isNotEmpty((Object)shiroUser) && ToolUtil.isNotEmpty(deque = USERSESSION.get(shiroUser.getId()))) {
            deque.remove(session.getId());
            USERSESSION.put(shiroUser.getId(), deque);
        }
    }

    @Override
    public void removeBySession(Session session, String connName) {
        String key;
        Deque<Serializable> deque;
        ShiroUser shiroUser = (ShiroUser)session.getAttribute((Object)"shiroUser");
        if (ToolUtil.isNotEmpty((Object)shiroUser) && ToolUtil.isNotEmpty(deque = USERSESSION.get(key = shiroUser.getId() + connName))) {
            deque.remove(session.getId());
            USERSESSION.put(key, deque);
        }
    }
}

