/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.lock;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import com.jxdinfo.hussar.core.shiro.lock.LoginLock;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

@DependsOn(value={"springContextHolder"})
public class RedisLoginLock
implements LoginLock {
    private RedisService redisService = (RedisService)SpringContextHolder.getBean(RedisService.class);
    private GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
    private ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
    RedisTemplate<String, Object> redisTemplate = this.redisService.getRedisTemplate();
    ValueOperations<String, Object> opsForValue = this.redisTemplate.opsForValue();
    int tryLoginTime = this.globalProperties.getTryLoginTime();
    int lockTime = this.globalProperties.getLockTime();

    @Override
    public boolean userIsLock(String userId) {
        return this.userLockState(userId, userId);
    }

    @Override
    public boolean userIsLock(String userId, String connName) {
        String key = userId + "-" + connName;
        return this.userLockState(key, userId);
    }

    private boolean userLockState(String key, String userId) {
        boolean flag = false;
        if ("LOCK".equals(this.opsForValue.get((Object)("shiro_is_lock:" + key)))) {
            flag = true;
        } else {
            this.iSysUsersService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"account_status", (Object)UserStatus.OK.getCode())).eq((Object)"user_account", (Object)userId)).eq((Object)"account_status", (Object)UserStatus.PWD_LOCK.getCode()));
        }
        return flag;
    }

    @Override
    public int userLockNum(String userId) {
        long count = this.opsForValue.increment((Object)("shiro_login_count:" + userId), 0L);
        return (int)count;
    }

    @Override
    public int userLockNum(String userId, String connName) {
        long count = this.opsForValue.increment((Object)("shiro_login_count:" + userId + "-" + connName), 0L);
        return (int)count;
    }

    @Override
    public boolean exisUser(String userId) {
        boolean flag = false;
        Object num = this.opsForValue.get((Object)("shiro_login_count:" + userId));
        if (ToolUtil.isNotEmpty((Object)num)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void addUserCache(String userId) {
        long count = this.opsForValue.increment((Object)("shiro_login_count:" + userId), 1L);
        if (count >= (long)this.tryLoginTime) {
            this.opsForValue.set((Object)("shiro_is_lock:" + userId), (Object)"LOCK");
            this.redisTemplate.expire((Object)("shiro_is_lock:" + userId), (long)this.lockTime, TimeUnit.HOURS);
        }
    }

    @Override
    public void removeUserCache(String userId) {
        this.redisTemplate.delete((Object)("shiro_login_count:" + userId));
    }

    @Override
    public void removeUserCache(String userId, String connName) {
        this.redisTemplate.delete((Object)("shiro_login_count:" + userId + "-" + connName));
    }

    @Override
    public void addUserCache(String userId, int tryLogin) {
        this.addNewUserCache(userId, tryLogin);
    }

    @Override
    public void addUserCache(String userId, String connName, int tryLogin) {
        String key = userId + "-" + connName;
        this.addNewUserCache(key, tryLogin);
    }

    private void addNewUserCache(String key, int tryLogin) {
        long count = this.opsForValue.increment((Object)("shiro_login_count:" + key), 1L);
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failHours = iSysBaseConfigService.getSysBaseConfig("fail_time");
        int hours = Integer.parseInt(failHours.getConfigValue());
        if (count == 1L) {
            this.redisTemplate.expire((Object)("shiro_login_count:" + key), (long)hours, TimeUnit.HOURS);
        }
        if (count >= (long)tryLogin) {
            SysBaseConfig sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("fail_lock_time");
            String failLockTime = sysBaseConfig.getConfigValue();
            int failTime = Integer.parseInt(failLockTime);
            this.opsForValue.set((Object)("shiro_is_lock:" + key), (Object)"LOCK");
            this.redisTemplate.expire((Object)("shiro_is_lock:" + key), (long)failTime, TimeUnit.HOURS);
        }
    }
}

