/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.lock;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.lock.LoginLock;
import com.jxdinfo.hussar.core.shiro.lock.UserLockModel;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class MapLoginLock
implements LoginLock {
    private static final String LOINLOCK = "Login_Lock";
    private static HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
    private GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
    private ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
    int tryLoginTime = this.globalProperties.getTryLoginTime();
    int lockTime = this.globalProperties.getLockTime();

    @Override
    public boolean userIsLock(String userId) {
        return this.userLockState(userId, userId);
    }

    @Override
    public boolean userIsLock(String userId, String connName) {
        String key = userId + "-" + connName;
        return this.userLockState(key, userId);
    }

    private boolean userLockState(String key, String userId) {
        boolean flag = false;
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, key);
        if (ToolUtil.isNotEmpty((Object)model) && ToolUtil.isNotEmpty((Object)model.getExpireTime())) {
            if (DateUtil.compareDate((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (Date)model.getExpireTime()) == -1) {
                flag = true;
            } else {
                this.iSysUsersService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"account_status", (Object)UserStatus.OK.getCode())).eq((Object)"user_account", (Object)userId)).eq((Object)"account_status", (Object)UserStatus.PWD_LOCK.getCode()));
            }
        } else {
            this.iSysUsersService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"account_status", (Object)UserStatus.OK.getCode())).eq((Object)"user_account", (Object)userId)).eq((Object)"account_status", (Object)UserStatus.PWD_LOCK.getCode()));
        }
        return flag;
    }

    @Override
    public int userLockNum(String userId) {
        int num = 0;
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, userId);
        if (ToolUtil.isNotEmpty((Object)model)) {
            num = model.getFailNum();
        }
        return num;
    }

    @Override
    public int userLockNum(String userId, String connName) {
        int num = 0;
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, userId + "-" + connName);
        if (ToolUtil.isNotEmpty((Object)model)) {
            num = model.getFailNum();
        }
        return num;
    }

    @Override
    public boolean exisUser(String userId) {
        boolean flag = false;
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, userId);
        if (ToolUtil.isNotEmpty((Object)model)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void addUserCache(String userId) {
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, userId);
        if (ToolUtil.isNotEmpty((Object)model)) {
            if (ToolUtil.isNotEmpty((Object)model.getExpireTime())) {
                model.setFailNum(0);
                model.setLockTime(null);
                model.setExpireTime(null);
            }
            model.setFailNum(model.getFailNum() + 1);
            if (model.getFailNum() >= this.tryLoginTime) {
                model.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                model.setExpireTime(DateUtil.addHour((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)this.lockTime));
            }
        } else {
            UserLockModel newModel = new UserLockModel();
            newModel.setUserid(userId);
            newModel.setFailNum(1);
            if (newModel.getFailNum() >= this.tryLoginTime) {
                newModel.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                newModel.setExpireTime(DateUtil.addHour((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)this.lockTime));
            }
            hussarCacheManager.setObject(LOINLOCK, userId, (Object)newModel);
        }
    }

    @Override
    public void removeUserCache(String userId) {
        hussarCacheManager.delete(LOINLOCK, userId);
    }

    @Override
    public void removeUserCache(String userId, String connName) {
        hussarCacheManager.delete(LOINLOCK, userId + "-" + connName);
    }

    @Override
    public void addUserCache(String userId, int tryLogin) {
        this.addNewUserCache(userId, userId, tryLogin);
    }

    @Override
    public void addUserCache(String userId, String connName, int tryLogin) {
        String key = userId + "-" + connName;
        this.addNewUserCache(key, userId, tryLogin);
    }

    private void addNewUserCache(String key, String userId, int tryLogin) {
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, key);
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("fail_lock_time");
        SysBaseConfig failHours = iSysBaseConfigService.getSysBaseConfig("fail_time");
        String failLockTime = sysBaseConfig.getConfigValue();
        int failTime = Integer.parseInt(failLockTime);
        int hours = Integer.parseInt(failHours.getConfigValue());
        if (ToolUtil.isNotEmpty((Object)model)) {
            if (ToolUtil.isNotEmpty((Object)model.getExpireTime())) {
                model.setFailNum(0);
                model.setLockTime(null);
                model.setExpireTime(null);
            }
            if (DateUtil.addHour((Date)model.getFirstFailTime(), (int)hours).getTime() < System.currentTimeMillis()) {
                model.setFailNum(0);
                model.setFirstFailTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                model.setLockTime(null);
                model.setExpireTime(null);
            }
            model.setFailNum(model.getFailNum() + 1);
            if (model.getFailNum() >= tryLogin) {
                model.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                model.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)failTime));
            }
        } else {
            UserLockModel newModel = new UserLockModel();
            newModel.setUserid(userId);
            newModel.setFirstFailTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            newModel.setFailNum(1);
            if (newModel.getFailNum() >= tryLogin) {
                newModel.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                newModel.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)failTime));
            }
            hussarCacheManager.setObject(LOINLOCK, key, (Object)newModel);
        }
    }
}

