/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.language;

import com.jxdinfo.hussar.core.redis.service.RedisService;
import com.jxdinfo.hussar.core.shiro.language.ILanguage;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Set;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.web.context.request.RequestContextHolder;

@DependsOn(value={"springContextHolder"})
public class RedisLanguage
implements ILanguage {
    private RedisService redisService = (RedisService)SpringContextHolder.getBean(RedisService.class);
    private RedisTemplate<String, Object> redisTemplate = this.redisService.getRedisTemplate();
    private ValueOperations<String, Object> opsForValue = this.redisTemplate.opsForValue();
    private static final String ZH_LANG_NAME = "zh";
    private static final String EN_LANG_NAME = "en";

    public RedisLanguage() throws IOException {
        this.init();
    }

    private void init() throws IOException {
        Properties zhProperties = this.loadLanguage("language/zh.properties");
        this.loadCache(zhProperties, ZH_LANG_NAME);
        Properties enProperties = this.loadLanguage("language/en.properties");
        this.loadCache(enProperties, EN_LANG_NAME);
    }

    private Properties loadLanguage(String path) throws IOException {
        Properties properties = new Properties();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);
        properties.load(in);
        return properties;
    }

    private void loadCache(Properties properties, String name) {
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String key : propertyNames) {
            String value = properties.getProperty(key);
            if (ToolUtil.isNotEmpty((Object)value)) {
                value = new String(value.getBytes(), StandardCharsets.UTF_8);
            }
            this.opsForValue.set((Object)(name + key), (Object)value);
        }
    }

    @Override
    public void setUserLangCache(String sessionId, String language) {
        this.opsForValue.set((Object)("user_lang" + sessionId), (Object)language);
    }

    @Override
    public String getResponseCacheValue(String key) {
        Object obj = null;
        if (ToolUtil.isNotEmpty((Object)RequestContextHolder.getRequestAttributes())) {
            String lang;
            String sessionId = RequestContextHolder.getRequestAttributes().getSessionId();
            Object langObj = this.opsForValue.get((Object)("user_lang" + sessionId));
            if (ToolUtil.isNotEmpty((Object)langObj) && EN_LANG_NAME.equals(lang = langObj.toString())) {
                obj = this.opsForValue.get((Object)(EN_LANG_NAME + key));
            }
        }
        if (ToolUtil.isNotEmpty(obj)) {
            return obj.toString();
        }
        obj = this.opsForValue.get((Object)(ZH_LANG_NAME + key));
        return ToolUtil.isNotEmpty((Object)obj) ? obj.toString() : null;
    }
}

