/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.language;

import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.language.ILanguage;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Set;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.context.request.RequestContextHolder;

@DependsOn(value={"springContextHolder"})
public class MapLanguage
implements ILanguage {
    private static HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
    private static final String ZH_LANG_NAME = "zh_response";
    private static final String EN_LANG_NAME = "en_response";

    public MapLanguage() throws IOException {
        this.init();
    }

    private void init() throws IOException {
        Properties zhProperties = this.loadLanguage("language/zh.properties");
        this.loadCache(zhProperties, ZH_LANG_NAME);
        Properties enProperties = this.loadLanguage("language/en.properties");
        this.loadCache(enProperties, EN_LANG_NAME);
    }

    private Properties loadLanguage(String path) throws IOException {
        Properties properties = new Properties();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        properties.load(reader);
        return properties;
    }

    private void loadCache(Properties properties, String name) {
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String key : propertyNames) {
            String value = properties.getProperty(key);
            if (ToolUtil.isNotEmpty((Object)value)) {
                value = new String(value.getBytes(), StandardCharsets.UTF_8);
            }
            hussarCacheManager.setObject(name, key, (Object)value);
        }
    }

    @Override
    public void setUserLangCache(String sessionId, String language) {
        hussarCacheManager.setObject("user_lang", sessionId, (Object)language);
    }

    @Override
    public String getResponseCacheValue(String key) {
        String lang;
        String sessionId;
        Object langObj;
        Object obj = null;
        if (ToolUtil.isNotEmpty((Object)RequestContextHolder.getRequestAttributes()) && ToolUtil.isNotEmpty((Object)(langObj = hussarCacheManager.getObject("user_lang", sessionId = RequestContextHolder.getRequestAttributes().getSessionId()))) && "en".equals(lang = langObj.toString())) {
            obj = hussarCacheManager.getObject(EN_LANG_NAME, key);
        }
        if (ToolUtil.isNotEmpty(obj)) {
            return obj.toString();
        }
        obj = hussarCacheManager.getObject(ZH_LANG_NAME, key);
        return ToolUtil.isNotEmpty((Object)obj) ? obj.toString() : null;
    }
}

