/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.factory;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.permit.LoginExceptionMailUtil;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserDataScopeService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.bsp.tenant.service.SysTenantService;
import com.jxdinfo.hussar.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.CancelException;
import com.jxdinfo.hussar.common.exception.DormancyException;
import com.jxdinfo.hussar.common.exception.HussarLockedAccountException;
import com.jxdinfo.hussar.common.exception.LoginIpRefuseException;
import com.jxdinfo.hussar.common.exception.LoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.TemporaryException;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"springContextHolder"})
public class ShiroFactroy
implements IShiro {
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private SysResourcesMapper resourcesMapper;
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysUserDataScopeService userDataScopeService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private HussarCacheManager hussarCacheManager;

    public static IShiro me() {
        return (IShiro)SpringContextHolder.getBean(IShiro.class);
    }

    @Override
    @Transactional(noRollbackFor={DormancyException.class, HussarLockedAccountException.class})
    public SysUsers user(String account) {
        SysBaseConfig sysBaseConfig;
        SysUsers user;
        String newAccount = account;
        if (!this.hussarProperties.getLoginUpperOpen().booleanValue()) {
            newAccount = newAccount.toUpperCase();
        }
        if (null == (user = (SysUsers)((Object)this.sysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)newAccount)).ne((Object)"ACCOUNT_STATUS", (Object)UserStatus.DELETE.getCode()), false)))) {
            throw new CredentialsException();
        }
        if (this.hussarProperties.getLoginUpperOpen().booleanValue() && !account.equals(user.getUserAccount())) {
            throw new CredentialsException();
        }
        if (UserStatus.LOCKED.getCode().equals(user.getAccountStatus())) {
            throw new HussarLockedAccountException(user.getUserName(), "\u8d26\u53f7\u88ab\u9501\u5b9a", "locking");
        }
        if (UserStatus.CANCEL.getCode().equals(user.getAccountStatus())) {
            throw new CancelException(user.getUserName(), "\u8d26\u53f7\u88ab\u6ce8\u9500", "logout");
        }
        if (UserStatus.DORMANCY.getCode().equals(user.getAccountStatus())) {
            throw new DormancyException(user.getUserName(), "\u8d26\u53f7\u5df2\u4f11\u7720", "dormancy");
        }
        if (Arrays.asList(Constants.MANAGE_USER).contains(user.getUserAccount())) {
            return user;
        }
        if (user.getLastLoginTime() != null) {
            Date lastLoginDate = user.getLastLoginTime();
            SysBaseConfig noLogin = this.iSysBaseConfigService.getSysBaseConfig("nologin_day");
            SysBaseConfig userAccountStatus = this.iSysBaseConfigService.getSysBaseConfig("user_account_status");
            String days = noLogin.getConfigValue();
            String status = userAccountStatus.getConfigValue();
            Date date = DateUtil.addDay((Date)lastLoginDate, (int)Integer.parseInt(days));
            if (date.getTime() < System.currentTimeMillis()) {
                SysUsers sysUsers = new SysUsers();
                sysUsers.setUserId(user.getUserId());
                sysUsers.setAccountStatus(UserStatus.LOCKED.getCode());
                this.sysUsersService.updateById((Object)sysUsers);
                if (UserStatus.DORMANCY.getCode().equals(status)) {
                    throw new DormancyException(user.getUserName(), "\u8d26\u53f7\u5df2\u4f11\u7720", "dormancy");
                }
                throw new HussarLockedAccountException(user.getUserName(), "\u8d85\u8fc7" + days + "\u5929\u672a\u767b\u5f55\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a", "notLoggedLocked", days);
            }
        }
        if (UserStatus.TEMPORARY.getCode().equals(user.getTypeProperty())) {
            String beginTime = user.getStartTime();
            String endTime = user.getExpiredTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(beginTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    throw new TemporaryException(user.getUserName(), "\u4e34\u65f6\u8d26\u53f7\u672a\u5728\u6709\u6548\u671f", "temporaryAccountExpired");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (ToolUtil.isNotEmpty((Object)((Object)(sysBaseConfig = this.iSysBaseConfigService.getSysBaseConfig("login_ip_limit"))))) {
            String loginTimeLimt;
            String loginIpLimit = sysBaseConfig.getConfigValue();
            if ("0".equals(loginIpLimit)) {
                List<String> forbidIpList;
                List<String> allowIpList;
                boolean flag = false;
                String loginIp = HttpKit.getIp();
                String allowIp = this.iSysBaseConfigService.getSysBaseConfig("allow_login_ip").getConfigValue();
                String forbidIp = this.iSysBaseConfigService.getSysBaseConfig("forbid_login_ip").getConfigValue();
                if (ToolUtil.isEmpty((Object)allowIp) && ToolUtil.isEmpty((Object)forbidIp)) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)allowIp) && ((allowIpList = Arrays.asList(allowIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)forbidIp) && !flag && (!(forbidIpList = Arrays.asList(forbidIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (!flag) {
                    LoginExceptionMailUtil.sendIPLimitMail(user.getUserName(), user.getUserAccount(), loginIp);
                    throw new LoginIpRefuseException(user.getUserName(), "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55", "ipForbiddenLogin");
                }
            }
            if ("0".equals(loginTimeLimt = this.iSysBaseConfigService.getSysBaseConfig("login_time_limit").getConfigValue())) {
                boolean flag = false;
                Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
                String startTime = this.iSysBaseConfigService.getSysBaseConfig("login_start_time").getConfigValue();
                String endTime = this.iSysBaseConfigService.getSysBaseConfig("login_end_time").getConfigValue();
                try {
                    Date dt1 = df.parse(startTime);
                    Date dt2 = df.parse(endTime);
                    Date now = df.parse(df.format(date));
                    if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                        flag = true;
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (!flag) {
                    throw new LoginTimeRefuseException(user.getUserName(), "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55", "timeForbiddenLogin");
                }
            }
        }
        if (this.globalProperties.getLoginTimeLimit().booleanValue() && "1".equals(user.getLoginTimeLimit())) {
            boolean flag = false;
            Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            String startTime = user.getAccessLoginStartTime();
            String endTime = user.getAccessLoginEndTime();
            try {
                Date dt1 = df.parse(startTime);
                Date dt2 = df.parse(endTime);
                Date now = df.parse(df.format(date));
                if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                    flag = true;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (!flag) {
                throw new LoginTimeRefuseException(user.getUserName(), "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55", "timeForbiddenLogin");
            }
        }
        if (this.globalProperties.getLoginIpLimit().booleanValue() && "1".equals(user.getLoginIpLimit())) {
            boolean canLogin = false;
            String loginIp = HttpKit.getIp();
            List<String> list = this.iSysUserIpService.selectUserIp(user.getUserId());
            for (String ip : list) {
                if (!StringUtils.equals((CharSequence)loginIp, (CharSequence)ip)) continue;
                canLogin = true;
                break;
            }
            if (!canLogin) {
                throw new LoginIpRefuseException(user.getUserName(), "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55", "ipForbiddenLogin");
            }
        }
        return user;
    }

    @Override
    public ShiroUser shiroUser(SysUsers user) {
        ShiroUser shiroUser = new ShiroUser();
        shiroUser.setId(user.getUserId());
        shiroUser.setAccount(user.getUserAccount());
        shiroUser.setDeptId(user.getDepartmentId());
        shiroUser.setEmployeeId(user.getEmployeeId());
        shiroUser.setDeptName(ConstantFactory.me().getDeptName(user.getDepartmentId()));
        shiroUser.setName(user.getUserName());
        shiroUser.setSecurityLevel(user.getSecurityLevel());
        shiroUser.setAccountStatus(user.getAccountStatus());
        List<String> rolesList = ConstantFactory.me().getRolesIdByUserId(user.getUserId());
        String employeeId = user.getEmployeeId();
        String departmentId = user.getDepartmentId();
        if (this.hussarConfig.getUseSeparation().booleanValue() && StringUtils.isNotEmpty((CharSequence)employeeId) && StringUtils.isNotEmpty((CharSequence)departmentId)) {
            List<String> roleList = ConstantFactory.me().getRolesIdByStruId(user.getDepartmentId());
            rolesList.addAll(roleList);
        }
        shiroUser.setRolesList(rolesList);
        shiroUser.setTenantCode(user.getTenantCode());
        shiroUser.setConnName(user.getConnName());
        shiroUser.setTenantId(user.getTenantId());
        shiroUser.setTenantCipher(user.getTenantCipher());
        return shiroUser;
    }

    @Override
    public List<String> getAuthInfo(ShiroUser shiroUser) {
        return ConstantFactory.me().getAuthInfo(shiroUser).get("userPermission");
    }

    @Override
    public List<String> findPermissionsByRoleId(String roleId) {
        List<String> resUrls = this.resourcesMapper.getResUrlsByRoleId(roleId);
        return resUrls;
    }

    @Override
    public String findRoleNameByRoleId(String roleId) {
        return ConstantFactory.me().getSingleRoleTip(roleId);
    }

    @Override
    public SimpleAuthenticationInfo info(ShiroUser shiroUser, SysUsers user, String realmName) {
        String credentials = user.getPassword();
        return new SimpleAuthenticationInfo((Object)shiroUser, (Object)credentials, realmName);
    }

    @Override
    public SysUsers userTenantInfo() {
        String connName;
        SysUsers user = new SysUsers();
        if (this.globalProperties.isTenantOpen() && ToolUtil.isNotEmpty((Object)(connName = DataSourceUtil.currentDsName()))) {
            user.setConnName(connName);
            if ("master".equals(connName)) {
                user.setTenantCode("000000");
                SysTenant tenant = (SysTenant)((Object)this.sysTenantService.getOne((Wrapper)new QueryWrapper().eq((Object)"TENANT_CODE", (Object)"000000")));
                if (ToolUtil.isNotEmpty((Object)((Object)tenant))) {
                    user.setTenantId(tenant.getBpmTenantId());
                    user.setTenantCipher(tenant.getBpmTenantCipher());
                }
            } else {
                SysTenant tenant = this.sysTenantService.getTenantByConnName(connName);
                if (ToolUtil.isNotEmpty((Object)((Object)tenant))) {
                    user.setTenantCode(tenant.getTenantCode());
                    user.setTenantId(tenant.getBpmTenantId());
                    user.setTenantCipher(tenant.getBpmTenantCipher());
                }
            }
        }
        return user;
    }

    @Override
    public Map<String, Object> getDataScopeInfo(ShiroUser shiroUser) {
        String type = (String)this.hussarCacheManager.getObject("data_scope_type", "data_scope_type:" + shiroUser.getId() + ":" + DataSourceUtil.currentDsName());
        HashSet<String> orgList = (HashSet<String>)this.hussarCacheManager.getObject("data_scope_list", "data_scope_list:" + shiroUser.getId() + ":" + DataSourceUtil.currentDsName());
        if (ToolUtil.isEmpty((Object)type)) {
            SysUsers sysUsers = this.sysUsersService.getUser(shiroUser.getId());
            orgList = new HashSet<String>();
            String userType = sysUsers.getDataScopeType();
            if (ToolUtil.isNotEmpty((Object)userType)) {
                type = userType;
                if ("5".equals(type)) {
                    List<String> orgIds = this.userDataScopeService.getOrgListByUserId(shiroUser.getId());
                    orgList.addAll(orgIds);
                }
            } else {
                type = this.sysRolesService.getRoleDataScopeByUserId(orgList, shiroUser.getId());
            }
            this.sysStruService.getDataScopeOrgList(orgList, type, sysUsers, shiroUser);
            this.hussarCacheManager.setObject("data_scope_type", "data_scope_type:" + shiroUser.getId() + ":" + DataSourceUtil.currentDsName(), (Object)type);
            this.hussarCacheManager.setObject("data_scope_list", "data_scope_list:" + shiroUser.getId() + ":" + DataSourceUtil.currentDsName(), orgList);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data_scope_type", type);
        map.put("data_scope_list", orgList);
        return map;
    }
}

