/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro;

import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class ShiroDbRealm
extends AuthorizingRealm {
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        IShiro shiroFactory = ShiroFactroy.me();
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        SysUsers tenantUser = shiroFactory.userTenantInfo();
        SysUsers user = shiroFactory.user(token.getUsername());
        user.setTenantCode(tenantUser.getTenantCode());
        user.setTenantId(tenantUser.getTenantId());
        user.setTenantCipher(tenantUser.getTenantCipher());
        user.setConnName(tenantUser.getConnName());
        ShiroUser shiroUser = shiroFactory.shiroUser(user);
        SimpleAuthenticationInfo info = shiroFactory.info(shiroUser, user, super.getName());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        IShiro shiroFactory = ShiroFactroy.me();
        ShiroUser shiroUser = (ShiroUser)principals.getPrimaryPrincipal();
        GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
        if (globalProperties.isTenantOpen()) {
            try {
                DataSourceUtil.changeTempDs((String)shiroUser.getConnName());
                AuthorizationInfo authorizationInfo = this.getAuthorizationInfo(shiroFactory, shiroUser);
                return authorizationInfo;
            }
            finally {
                DataSourceUtil.poll();
            }
        }
        return this.getAuthorizationInfo(shiroFactory, shiroUser);
    }

    private AuthorizationInfo getAuthorizationInfo(IShiro shiroFactory, ShiroUser shiroUser) {
        List<String> permissionList = shiroFactory.getAuthInfo(shiroUser);
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        info.addStringPermissions(permissionList);
        return info;
    }
}

