/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.redis.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.redis.model.RedisInfoDetail;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/redis1"})
@ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
public class RedisMonitorController {
    private static Logger logger = LogManager.getLogger(RedisMonitorController.class);
    @Autowired
    RedisService redisService;
    @Value(value="${hussar.stand-alone}")
    private boolean stand_alone;

    @RequestMapping(value={"/getAllRedisDatabaseList"})
    @BussinessLog(key="/redis1/getAllRedisDatabaseList", type="04", value="\u83b7\u53d6redis\u5217\u8868")
    @ResponseBody
    public ApiResponse<Object> getAllRedisDatabaseList1() {
        List list = this.redisService.getAllDataBaseForRedis();
        return ApiResponse.data((Object)list);
    }

    @RequiresPermissions(value={"redis:getKeysSize"})
    @RequestMapping(value={"/getKeysSize"})
    @BussinessLog(key="/redis1/getKeysSize", type="04", value="\u83b7\u53d6\u5f53\u524d\u6570\u636e\u5e93\u4e2dkey\u7684\u6570\u91cf")
    @ResponseBody
    public ApiResponse<String> getKeysSize() {
        String result = JSON.toJSONString((Object)this.redisService.getKeysSize());
        return ApiResponse.data((Object)result);
    }

    @RequiresPermissions(value={"redis:getMemeryInfo"})
    @RequestMapping(value={"/getMemeryInfo"})
    @BussinessLog(key="/redis1/getMemeryInfo", type="04", value="\u83b7\u53d6\u5f53\u524d\u6570\u636e\u5e93\u5185\u5b58\u4f7f\u7528\u5927\u5c0f\u60c5\u51b5")
    @ResponseBody
    public ApiResponse<String> getMemeryInfo() {
        String result = JSON.toJSONString((Object)this.redisService.getMemeryInfo());
        return ApiResponse.data((Object)result);
    }

    @RequiresPermissions(value={"redis:redisMonitor"})
    @RequestMapping(value={"/ridList"})
    @BussinessLog(key="/redis1/ridList", type="04", value="\u83b7\u53d6redis\u7684info")
    @ResponseBody
    public ApiResponse<List<RedisInfoDetail>> redisMonitor() {
        List ridList = this.redisService.getRedisInfo();
        HashMap map = new HashMap();
        return ApiResponse.data((Object)ridList);
    }
}

