/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.redis.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"redis"})
@ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
public class RedisController {
    private static Logger logger = LogManager.getLogger(RedisController.class);
    @Autowired
    RedisService redisService;
    @Value(value="${hussar.stand-alone}")
    private boolean stand_alone;

    @RequiresPermissions(value={"redis:redisMonitor"})
    @RequestMapping(value={"redisMonitor"})
    @BussinessLog(key="/redis/redisMonitor", type="04", value="\u8df3\u8f6c\u5230\u76d1\u63a7\u9875\u9762")
    public String redisMonitor(Model model) {
        List ridList = this.redisService.getRedisInfo();
        model.addAttribute("infoList", (Object)ridList);
        return "/core/redis/redisMonitor.html";
    }

    @RequiresPermissions(value={"redis:logEmpty"})
    @RequestMapping(value={"logEmpty"})
    @BussinessLog(key="/redis/logEmpty", type="03", value="\u6e05\u7a7a\u65e5\u5fd7\u6309\u94ae")
    @ResponseBody
    public String logEmpty() {
        return this.redisService.logEmpty();
    }

    @RequiresPermissions(value={"redis:getKeysSize"})
    @RequestMapping(value={"getKeysSize"})
    @BussinessLog(key="/redis/getKeysSize", type="04", value="\u83b7\u53d6\u5f53\u524d\u6570\u636e\u5e93\u4e2dkey\u7684\u6570\u91cf")
    @ResponseBody
    public String getKeysSize() {
        return JSON.toJSONString((Object)this.redisService.getKeysSize());
    }

    @RequiresPermissions(value={"redis:getMemeryInfo"})
    @RequestMapping(value={"getMemeryInfo"})
    @BussinessLog(key="/redis/getMemeryInfo", type="04", value="\u83b7\u53d6\u5f53\u524d\u6570\u636e\u5e93\u5185\u5b58\u4f7f\u7528\u5927\u5c0f\u60c5\u51b5")
    @ResponseBody
    public String getMemeryInfo() {
        return JSON.toJSONString((Object)this.redisService.getMemeryInfo());
    }

    @RequiresPermissions(value={"redis:manageView"})
    @RequestMapping(value={"/manageView"})
    @BussinessLog(key="/redis/manageView", type="04", value="\u8df3\u8f6c\u5230redis\u7ba1\u7406\u7684\u9875\u9762")
    public String index() {
        return "/core/redis/redisManage.html";
    }

    @RequiresPermissions(value={"redis:getAllRedisDatabaseList"})
    @RequestMapping(value={"getAllRedisDatabaseList"})
    @BussinessLog(key="/redis/getAllRedisDatabaseList", type="04", value="\u83b7\u53d6\u5f53\u524d\u6570\u636e\u5e93\u4e2d\u6240\u6709db\u7684map")
    @ResponseBody
    public Object getAllRedisDatabaseList() {
        return this.redisService.getAllDataBaseForRedis();
    }

    @RequiresPermissions(value={"redis:showRedisDBValue"})
    @RequestMapping(value={"/showRedisDBValue"})
    @BussinessLog(key="/redis/showRedisDBValue", type="04", value="\u83b7\u53d6\u67d0redis db\u4e2d\u7684\u5168\u90e8\u952e\u503c")
    @ResponseBody
    public Object showNoSQLDBValue(@RequestParam(value="NoSQLDbName", required=false) String noSQLDbName, @RequestParam(value="selectKey", required=false) String selectKey, @RequestParam(value="page", defaultValue="1") int pageNo, @RequestParam(value="limit", defaultValue="20") int limit) {
        String newSelectKey = selectKey;
        Page page = new Page((long)pageNo, (long)limit);
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        if (StringUtils.isBlank((CharSequence)noSQLDbName)) {
            result.put("code", 0);
            result.put("count", 0);
            result.put("data", null);
            return result;
        }
        if (newSelectKey == null) {
            newSelectKey = "nokey";
        }
        List list = this.redisService.getNoSQLDBForRedis(page, noSQLDbName, newSelectKey).getRecords();
        result.put("code", 0);
        result.put("count", page.getTotal());
        result.put("data", list);
        return result;
    }

    @RequiresPermissions(value={"redis:deleteNoSQLKeys"})
    @RequestMapping(value={"/deleteNoSQLKeys"}, method={RequestMethod.POST})
    @BussinessLog(key="/redis/deleteNoSQLKeys", type="02", value="\u5220\u9664redis key")
    @ResponseBody
    public Map<String, Object> deleteNoSQLKeys(@RequestParam(value="NoSQLDbName") String noSQLDbName, @RequestParam(value="keys") String keys) {
        String message = "";
        String status = "";
        try {
            JSONArray arr = JSON.parseArray((String)keys);
            String[] strarr = (String[])arr.toArray((Object[])new String[arr.size()]);
            this.redisService.deleteNoSQLKeyForRedis(noSQLDbName, strarr);
            message = "\u5220\u9664\u6210\u529f";
            status = "success";
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            message = e.getMessage();
            status = "fail";
        }
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("message", message);
        map.put("status", status);
        return map;
    }
}

