/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.log.factory;

import com.jxdinfo.hussar.bsp.permit.model.SysSecurityLog;
import com.jxdinfo.hussar.common.constant.state.LogSucceed;
import com.jxdinfo.hussar.common.constant.state.LogType;
import com.jxdinfo.hussar.core.constant.LevelEvent;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;

public class LogFactory {
    public static SysSecurityLog createSysSecurityLog(LogType logType, ShiroUser user, String bussinessName, String className, String methodName, String msg, String succeed, Map<String, String> info, String type, String levelEvent) {
        String params;
        SysSecurityLog sysSecurityLog = new SysSecurityLog();
        sysSecurityLog.setLogId(null);
        sysSecurityLog.setLogType(type);
        sysSecurityLog.setLogTypeName(logType.getMessage());
        sysSecurityLog.setUserId(user.getId());
        sysSecurityLog.setUserAccount(user.getAccount());
        sysSecurityLog.setSessionId(info.get("sessionId"));
        sysSecurityLog.setUserName(user.getName());
        sysSecurityLog.setLocaladdr(info.get("localIp"));
        sysSecurityLog.setLocalport(info.get("localPort"));
        sysSecurityLog.setLocalhost(info.get("localHost"));
        sysSecurityLog.setRemoteaddr(info.get("ip"));
        sysSecurityLog.setRemoteport(info.get("port"));
        sysSecurityLog.setRemotehost(info.get("host"));
        sysSecurityLog.setLevelEvent(levelEvent);
        sysSecurityLog.setState(succeed);
        sysSecurityLog.setLogTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysSecurityLog.setCorporationId(user.getDeptId());
        sysSecurityLog.setCorporationName(user.getDeptName());
        StringBuilder content = new StringBuilder();
        content.append("\u7c7b\u540d:").append(className).append(";").append("\n");
        content.append("\u65b9\u6cd5\u540d:").append(methodName).append(";").append("\n");
        String lineNumber = info.get("lineNumber");
        if (ToolUtil.isNotEmpty((Object)lineNumber)) {
            content.append("\u4ee3\u7801\u884c\u6570:").append(lineNumber).append(";").append("\n");
        }
        if (ToolUtil.isNotEmpty((Object)(params = info.get("params")))) {
            content.append("\u8bf7\u6c42\u53c2\u6570").append(params).append(";").append("\n");
        }
        content.append("\u64cd\u4f5c\u63cf\u8ff0:").append(bussinessName).append(";").append("\n");
        if (ToolUtil.isNotEmpty((Object)msg)) {
            content.append("\u5177\u4f53\u64cd\u4f5c:").append(msg).append(";").append("\n");
        }
        sysSecurityLog.setLogContent(content.toString());
        return sysSecurityLog;
    }

    public static SysSecurityLog createLoginLog(LogType logType, ShiroUser user, String msg, Map<String, String> info, String type) {
        SysSecurityLog sysSecurityLog = new SysSecurityLog();
        sysSecurityLog.setLogId(null);
        sysSecurityLog.setLogType(type);
        sysSecurityLog.setLogTypeName(logType.getMessage());
        sysSecurityLog.setUserId(user.getId());
        sysSecurityLog.setUserAccount(user.getAccount());
        sysSecurityLog.setSessionId(info.get("sessionId"));
        sysSecurityLog.setUserName(user.getName());
        sysSecurityLog.setLocaladdr(info.get("localIp"));
        sysSecurityLog.setLocalport(info.get("localPort"));
        sysSecurityLog.setLocalhost(info.get("localHost"));
        sysSecurityLog.setRemoteaddr(info.get("ip"));
        sysSecurityLog.setRemoteport(info.get("port"));
        sysSecurityLog.setRemotehost(info.get("host"));
        sysSecurityLog.setLevelEvent(LevelEvent.SYSTEM.value());
        sysSecurityLog.setState(LogSucceed.SUCCESS.value());
        sysSecurityLog.setLogTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysSecurityLog.setCorporationId(user.getDeptId());
        sysSecurityLog.setCorporationName(user.getDeptName());
        sysSecurityLog.setResourceAlias(msg);
        StringBuffer content = new StringBuffer();
        content.append("\u64cd\u4f5c\u63cf\u8ff0:" + msg).append(";");
        sysSecurityLog.setLogContent(content.toString());
        return sysSecurityLog;
    }

    public static SysSecurityLog createLoginExceptionLog(LogType loginFail, String username, String msg, Map<String, String> info, String type) {
        SysSecurityLog sysSecurityLog = new SysSecurityLog();
        sysSecurityLog.setLogId(null);
        sysSecurityLog.setLogType(type);
        sysSecurityLog.setLogTypeName(loginFail.getMessage());
        sysSecurityLog.setSessionId(info.get("sessionId"));
        sysSecurityLog.setUserId(username);
        sysSecurityLog.setUserAccount(username);
        sysSecurityLog.setUserName(username);
        sysSecurityLog.setLocaladdr(info.get("localIp"));
        sysSecurityLog.setLocalport(info.get("localPort"));
        sysSecurityLog.setLocalhost(info.get("localHost"));
        sysSecurityLog.setRemoteaddr(info.get("ip"));
        sysSecurityLog.setRemoteport(info.get("port"));
        sysSecurityLog.setRemotehost(info.get("host"));
        sysSecurityLog.setLevelEvent(LevelEvent.SYSTEM.value());
        sysSecurityLog.setState(LogSucceed.FAIL.value());
        sysSecurityLog.setLogTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        StringBuffer content = new StringBuffer();
        content.append("\u64cd\u4f5c\u63cf\u8ff0:\u767b\u5f55\u5f02\u5e38\uff01" + msg).append(";");
        sysSecurityLog.setLogContent(content.toString());
        return sysSecurityLog;
    }

    public static SysSecurityLog createFileLog(LogType logType, ShiroUser user, String msg, Map<String, String> info, String type) {
        SysSecurityLog sysSecurityLog = new SysSecurityLog();
        sysSecurityLog.setLogId(null);
        sysSecurityLog.setLogType(type);
        sysSecurityLog.setLogTypeName(logType.getMessage());
        sysSecurityLog.setUserId(user.getId());
        sysSecurityLog.setUserAccount(user.getAccount());
        sysSecurityLog.setSessionId(info.get("sessionId"));
        sysSecurityLog.setUserName(user.getName());
        sysSecurityLog.setLocaladdr(info.get("localIp"));
        sysSecurityLog.setLocalport(info.get("localPort"));
        sysSecurityLog.setLocalhost(info.get("localHost"));
        sysSecurityLog.setRemoteaddr(info.get("ip"));
        sysSecurityLog.setRemoteport(info.get("port"));
        sysSecurityLog.setRemotehost(info.get("host"));
        sysSecurityLog.setLevelEvent(LevelEvent.SYSTEM.value());
        sysSecurityLog.setState(LogSucceed.SUCCESS.value());
        sysSecurityLog.setLogTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        sysSecurityLog.setCorporationId(user.getDeptId());
        sysSecurityLog.setCorporationName(user.getDeptName());
        sysSecurityLog.setResourceAlias(msg);
        StringBuffer content = new StringBuffer();
        content.append("\u64cd\u4f5c\u63cf\u8ff0:" + msg).append(";");
        if (ToolUtil.isNotEmpty((Object)info.get("filePath"))) {
            content.append("\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84:" + info.get("filePath")).append(",");
        }
        sysSecurityLog.setLogContent(content.toString());
        return sysSecurityLog;
    }
}

