/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.license.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.ApiException;
import com.jxdinfo.hussar.common.firewall.xss.XssChecker;
import com.jxdinfo.hussar.core.ContactInfomation;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.MessageTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.license.model.LicenseRecord;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/license"})
public class LicenseController
extends BaseController {
    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"license:view"})
    @BussinessLog(key="/license/view", type="04", value="\u6388\u6743\u4fe1\u606f\u9875\u9762")
    public String index(Model model) {
        List contactList = ContactInfomation.getContactInfo();
        model.addAttribute("contactList", (Object)contactList);
        String type = super.getPara("type");
        if ("1".equals(type)) {
            String appliCode = LicenseInfo.generateRequestSN();
            model.addAttribute("requestSN", (Object)appliCode);
            if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
                return "/core/license/errorLicense.html";
            }
            return "/core/license/noLicense.html";
        }
        if (this.isLicenseValid()) {
            LicenseRecord lr = new LicenseRecord();
            lr.setStartDate(DateUtil.format((Date)LicenseInfo.getStartDate(), (String)"yyyy-MM-dd"));
            lr.setEndDate(DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy-MM-dd"));
            Integer licenseType = LicenseInfo.getLicenseType();
            lr.setProjectName(LicenseInfo.getProjectName());
            lr.setNeedLicense(false);
            lr.setNeedWarning(false);
            if (licenseType == 0) {
                lr.setProjectName(LicenseInfo.getProjectName() + " < \u5269\u4f59\u53ef\u8bbf\u95ee\u6b21\u6570\uff1a" + LicenseInfo.getRequestLimit() + " >");
                lr.setLicenseType("\u5f00\u53d1\u73af\u5883\u6388\u6743");
                lr.setNeedLicense(true);
            } else if (licenseType == 1) {
                lr.setLicenseType("\u90e8\u7f72\u6388\u6743");
                if (LicenseInfo.nearEndDateWarning()) {
                    lr.setNeedLicense(true);
                    lr.setNeedWarning(true);
                } else if (LicenseInfo.needWarning()) {
                    lr.setNeedLicense(true);
                } else {
                    lr.setNeedLicense(false);
                    lr.setNeedWarning(false);
                }
            } else if (licenseType == 2) {
                lr.setLicenseType("VOL\u6279\u91cf\u6388\u6743");
            } else if (licenseType == 3) {
                lr.setProjectName(LicenseInfo.getProjectName() + " < \u5269\u4f59\u53ef\u8bbf\u95ee\u6b21\u6570\uff1a" + LicenseInfo.getRequestLimit() + " >");
                lr.setLicenseType("\u5f00\u53d1\u8005\u6388\u6743");
            } else if (licenseType == 5) {
                lr.setLicenseType("\u6b63\u5f0f\u6388\u6743");
                lr.setEndDate("\u4e0d\u9650");
            } else {
                lr.setProjectName(LicenseInfo.getProjectName() + " < \u5269\u4f59\u53ef\u8bbf\u95ee\u6b21\u6570\uff1a" + LicenseInfo.getRequestLimit() + " >");
                lr.setLicenseType("\u8bd5\u7528\u73af\u5883\u6388\u6743");
            }
            model.addAttribute("license", (Object)lr);
            return "/core/license/hasLicense.html";
        }
        String appliCode = LicenseInfo.generateRequestSN();
        model.addAttribute("requestSN", (Object)appliCode);
        if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
            return "/core/license/errorLicense.html";
        }
        return "/core/license/noLicense.html";
    }

    @RequiresPermissions(value={"license:upload"})
    @RequestMapping(method={RequestMethod.POST}, path={"/upload"})
    @BussinessLog(key="/license/upload", type="03", value="\u6388\u6743\u6587\u4ef6\u4e0a\u4f20")
    @ResponseBody
    public Tip uploadLicenseFile(@RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (!StringUtils.isEmpty((CharSequence)XssChecker.checkXss(fileName))) {
            throw new ApiException(HttpCode.BAD_REQUEST.value().intValue(), "invalid request , xss code:" + fileName);
        }
        if (!"hussar_V8.lic".equals(fileName)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u8be5\u6388\u6743\u6587\u4ef6\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u540d\u662f\u5426\u6b63\u786e\uff01");
        }
        try {
            file.transferTo(new File(LicenseInfo.getUploadPath() + "hussar_V8.lic"));
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
        }
        if (this.checkLicense()) {
            this.updateLicense();
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u8be5\u6388\u6743\u6587\u4ef6\u65e0\u6548\uff01");
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/check"})
    @ResponseBody
    public Tip check() {
        boolean isTrial = SecurityUtil.isTrial();
        if (isTrial) {
            JSONObject json = new JSONObject();
            json.put("startDate", (Object)DateUtil.format((Date)LicenseInfo.getStartDate(), (String)"yyyy.MM.dd"));
            json.put("endDate", (Object)DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy.MM.dd"));
            json.put("limit", (Object)LicenseInfo.getRequestLimit());
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), json.toJSONString());
        }
        JSONObject json = new JSONObject();
        json.put("message", (Object)("\u6388\u6743\u5c06\u5728" + DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy.MM.dd") + "\u8fc7\u671f\uff0c\u8bf7\u5c3d\u5feb\u7533\u8bf7\u6388\u6743"));
        if (LicenseInfo.nearEndDateWarning()) {
            json.put("days", (Object)"7");
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), json.toJSONString());
        }
        if (LicenseInfo.needWarning()) {
            json.put("days", (Object)"30");
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), json.toJSONString());
        }
        return new MessageTip(LicenseInfo.toJSONString());
    }

    private boolean isLicenseValid() {
        return LicenseInfo.isLicenseValidity();
    }

    private boolean checkLicense() {
        return LicenseInfo.checkLicense();
    }

    private void updateLicense() {
        LicenseInfo.update();
    }
}

