/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.intercept;

import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.language.ILanguage;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LanguageInterceptor
implements HandlerInterceptor {
    @Autowired
    private GlobalProperties globalProperties;
    private static final String LANGUAGE_COOKIE = "internationalization";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ILanguage language = (ILanguage)SpringContextHolder.getBean(ILanguage.class);
        Cookie[] cookies = request.getCookies();
        boolean hasCookie = false;
        String lang = "";
        if (ToolUtil.isNotEmpty((Object)cookies)) {
            for (Cookie cookie : cookies) {
                if (!LANGUAGE_COOKIE.equals(cookie.getName())) continue;
                hasCookie = true;
                lang = cookie.getValue();
                break;
            }
        }
        if (hasCookie) {
            language.setUserLangCache(request.getSession().getId(), lang);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    }
}

