/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.intercept;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.datasource.dao.SysDataSourceMapper;
import com.jxdinfo.hussar.bsp.datasource.model.SysDataSource;
import com.jxdinfo.hussar.common.annotion.DynamicDS;
import com.jxdinfo.hussar.common.exception.HussarUndeclaredThrowableException;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class DynamicDataSourceInterceptor
implements MethodInterceptor {
    private static SysDataSourceMapper sysDataSourceMapper = (SysDataSourceMapper)SpringContextHolder.getBean(SysDataSourceMapper.class);
    private static DruidProperties druidProperties = (DruidProperties)SpringContextHolder.getBean(DruidProperties.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        DynamicDS dynamicDS = methodInvocation.getMethod().getAnnotation(DynamicDS.class);
        if (dynamicDS != null) {
            if (!dynamicDS.isIntercept()) {
                return methodInvocation.proceed();
            }
            String connName = dynamicDS.value();
            if (ToolUtil.isEmpty((Object)connName)) {
                return this.invokeByCurrentTenant(methodInvocation);
            }
            return this.changeDataSource(methodInvocation, connName);
        }
        return this.invokeByCurrentTenant(methodInvocation);
    }

    private Object invokeByCurrentTenant(MethodInvocation methodInvocation) throws Throwable {
        ShiroUser shiroUser;
        try {
            shiroUser = ShiroKit.getUser();
        }
        catch (HussarUndeclaredThrowableException e) {
            shiroUser = null;
        }
        if (ToolUtil.isEmpty((Object)shiroUser)) {
            return methodInvocation.proceed();
        }
        if ("000000".equals(shiroUser.getTenantCode())) {
            return methodInvocation.proceed();
        }
        String connName = shiroUser.getConnName();
        return this.changeDataSource(methodInvocation, connName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object changeDataSource(MethodInvocation methodInvocation, String connName) throws Throwable {
        boolean flag = true;
        try {
            if (ToolUtil.isEmpty((Object)DataSourceUtil.getDataSource((String)connName))) {
                flag = false;
            }
        }
        catch (RuntimeException e) {
            flag = false;
        }
        if (!flag) {
            SysDataSource dataSource = (SysDataSource)((Object)sysDataSourceMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"conn_name", (Object)connName)).eq((Object)"is_deleted", (Object)"0")));
            DataSourceProperty property = new DataSourceProperty();
            property.setDruid(druidProperties.getDruid());
            property.setPoolName(connName);
            property.setDriverClassName(dataSource.getDriverClass());
            property.setUrl(dataSource.getJdbcUrl());
            property.setUsername(dataSource.getUserName());
            property.setPassword(dataSource.getPassword());
            DataSourceUtil.addDataSource((DataSourceProperty)property);
        }
        try {
            DataSourceUtil.changeTempDs((String)connName);
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            DataSourceUtil.poll();
        }
    }
}

