/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.intercept;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.datasource.dao.SysDataSourceMapper;
import com.jxdinfo.hussar.bsp.datasource.model.SysDataSource;
import com.jxdinfo.hussar.bsp.tenant.dao.SysTenantMapper;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SM4Util;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"springContextHolder"})
public class BpmDataSourceInterceptor
implements MethodInterceptor {
    private SysTenantMapper sysTenantMapper = (SysTenantMapper)SpringContextHolder.getBean(SysTenantMapper.class);
    private SysDataSourceMapper sysDataSourceMapper = (SysDataSourceMapper)SpringContextHolder.getBean(SysDataSourceMapper.class);
    private DruidProperties druidProperties = (DruidProperties)SpringContextHolder.getBean(DruidProperties.class);
    public static final String KEY = "admin#$%^kopoiuy";

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String dbId;
        SysDataSource sysDataSource;
        Map map = HttpKit.getRequestParameters();
        String encryption = (String)map.get("tenantId");
        if (encryption == null) {
            return methodInvocation.proceed();
        }
        String tenantId = SM4Util.decrypt((String)encryption, (String)KEY);
        SysTenant sysTenant = (SysTenant)((Object)this.sysTenantMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"BPM_TENANT_ID", (Object)tenantId)));
        if (sysTenant == null) {
            return methodInvocation.proceed();
        }
        if (!"000000".equals(sysTenant.getTenantCode()) && ToolUtil.isNotEmpty((Object)((Object)(sysDataSource = (SysDataSource)((Object)this.sysDataSourceMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"DB_ID", (Object)(dbId = sysTenant.getDbId())))))))) {
            return this.changeTenant(methodInvocation, sysDataSource);
        }
        return methodInvocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object changeTenant(MethodInvocation methodInvocation, SysDataSource sysDataSource) throws Throwable {
        String connName = sysDataSource.getConnName();
        boolean flag = true;
        try {
            if (ToolUtil.isEmpty((Object)DataSourceUtil.getDataSource((String)connName))) {
                flag = false;
            }
        }
        catch (RuntimeException e) {
            flag = false;
        }
        if (!flag) {
            DataSourceProperty property = new DataSourceProperty();
            property.setDruid(this.druidProperties.getDruid());
            property.setPoolName(connName);
            property.setDriverClassName(sysDataSource.getDriverClass());
            property.setUrl(sysDataSource.getJdbcUrl());
            property.setUsername(sysDataSource.getUserName());
            property.setPassword(sysDataSource.getPassword());
            DataSourceUtil.addDataSource((DataSourceProperty)property);
        }
        try {
            DataSourceUtil.changeTempDs((String)connName);
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            DataSourceUtil.poll();
        }
    }
}

