/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.intercept;

import com.jxdinfo.hussar.common.exception.ApiException;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.aop.NoRepeatMethod;
import com.jxdinfo.hussar.core.cache.HussarCacheItem;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.filter.HussarPathMatcher;
import com.jxdinfo.hussar.core.filter.PatternMatcher;
import com.jxdinfo.hussar.core.util.MD5Util;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class AntiReplayHandlerInterceptor
implements HandlerInterceptor {
    private static Logger LOGGER = LoggerFactory.getLogger(AntiReplayHandlerInterceptor.class);
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private GlobalProperties global;
    protected PatternMatcher pathMatcher = HussarPathMatcher.getInstance();
    private Set<String> autoComplationPattern;

    @PostConstruct
    public void init() {
        this.autoComplationPattern = new HashSet<String>();
        this.autoComplationPattern.add("com.jxdinfo.hussar.**.controller");
        String scanPackages = this.global.getAntiReplayScanPackage();
        if (scanPackages != null && scanPackages.trim().length() != 0) {
            this.autoComplationPattern.addAll(Arrays.asList(scanPackages.split("\\s*,\\s*")));
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        Method method = ((HandlerMethod)handler).getMethod();
        String packageName = method.getDeclaringClass().getPackage().getName();
        NoRepeatMethod noRepeatMethod = method.getAnnotation(NoRepeatMethod.class);
        boolean isHussarPackage = this.isHussarPackage(packageName);
        if (noRepeatMethod == null && !isHussarPackage) {
            return true;
        }
        long timeout = this.global.getAntiReplayTimeout();
        if (timeout > 0L) {
            String cacheKey;
            Object cache;
            long methodTimeout = -1L;
            if (noRepeatMethod != null) {
                methodTimeout = noRepeatMethod.timeout();
            }
            if (methodTimeout > 0L) {
                timeout = methodTimeout;
            }
            if ((cache = this.hussarCacheManager.getObject("Anti-replay", cacheKey = this.getKey(request, method))) == null) {
                this.hussarCacheManager.setObject("Anti-replay", cacheKey, (Object)"Anti", timeout, TimeUnit.MILLISECONDS);
            }
            if (cache instanceof HussarCacheItem) {
                HussarCacheItem item = (HussarCacheItem)cache;
                long currentTime = System.currentTimeMillis();
                if (item.getCacheTime() > 0L && currentTime - item.getCreateTime() > item.getCacheTime()) {
                    this.hussarCacheManager.delete("Anti-replay", cacheKey);
                    return true;
                }
                if (item.getValue() != null && "Anti".equals(item.getValue())) {
                    throw new ApiException(HttpCode.BAD_REQUEST.value().intValue());
                }
                this.hussarCacheManager.setObject("Anti-replay", cacheKey, (Object)"Anti", timeout, TimeUnit.MILLISECONDS);
            }
        }
        return true;
    }

    private boolean isHussarPackage(String packageName) {
        for (String string : this.autoComplationPattern) {
            if (!this.pathMatcher.matches(string, packageName)) continue;
            return true;
        }
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            NoRepeatMethod noRepeatMethod = method.getAnnotation(NoRepeatMethod.class);
            String packageName = method.getDeclaringClass().getPackage().getName();
            boolean isHussarPackage = this.isHussarPackage(packageName);
            if (noRepeatMethod == null && !isHussarPackage) {
                return;
            }
        }
    }

    private String getKey(HttpServletRequest request, Method method) {
        String sessionId = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getSessionId();
        String token = request.getHeader("x-sign-token");
        String uri = request.getRequestURI();
        String requestKey = String.format("%s#%s", method.getDeclaringClass().getName(), method.getName());
        String key = MD5Util.encrypt((String)String.format("%s_%s_%s_%d", sessionId, token, uri, Math.abs(requestKey.hashCode())));
        LOGGER.debug("Anti-replay-key\uff1aAnti-replay-" + key);
        return "Anti-replay-" + key;
    }
}

